#-*-coding:utf-8-*-
from twisted.python import log
from ead2.backend.actions.lib.logparser import file_listing, logparsing
from ead2.backend.actions import tools
zone_indices = {'admin':0,
                'pedago':1,
                'web3':2}


def get_validate_btn(server_nb, name):
    """ renvoie la description du bouton valider """
    href= tools.make_long_form_link(server_nb, name, True, ['log_request'], 'div_log_table_container')
    title='Consulter'
    libelle='Valider'
    icone='/image/ok.gif'
    return dict(href=href,title=title,libelle=libelle,icone=icone)

def get_visit_form(zone):
    """ renvoie la description du formulaire de consultation de logs """
    zone = zone_indices[zone]
    logs = file_listing.get_logs_for_form(zone)
    beg_day_select = {'name':"beg_day", 'libelle':"Visite du:", "options":logs}
    end_day_select = {'name':"end_day", 'libelle':"Au:", "options":logs}
    hours = [{'name':str(hour), 'libelle':"%s heure"%str(hour)}for hour in range(25)]
    hours.insert(0,{'name':'vide', 'libelle':'', 'default':'ok'})
    hour_deb = {'name':'deb_hour', 'libelle':'Entre:', 'options':[{'name':'','options':hours}]}
    hour_end = {'name':'end_hour', 'libelle':'Et:', 'options':[{'name':'','options':hours}]}
    ip = {'name':'ip', 'libelle':"Depuis l'Ip"}
    login = {'name':'login', 'libelle':'Par:'}
    nums = [{'name':str(10*num), 'libelle':str(10*num)}for num in range(6)[1:]]
    size = {'name':'size', 'libelle':'par page de', 'options':[{'name':'', 'options':nums}]}
    denied = {'name':'denied', 'libelle':'', '_libelle':'Seulement les accès refusés', 'value':'ok'}
    return dict(beg_day_select=beg_day_select,
                end_day_select=end_day_select,
                hour_deb=hour_deb,
                hour_end=hour_end,
                ip=ip,
                login=login,
                size=size,
                denied=denied)

### methodes qui renvoient les logs
def valid_log_request(zone, server_nb, name, result):
    """ renvoie les logs demandés depuis le retour de formulaire (page=1)"""
    zone = zone_indices[zone]
    for i in ('deb_hour', 'end_hour', 'beg_day', 'ip', 'login', 'end_day', 'size', 'denied'):
        if i not in result:
            log.err("Erreur: navigation_visit.py, il manque des données pour le parsing.")
            raise MissingValue("Erreur : Il manque des données pour le parsing")
    ## recuperation des valeurs
    beg, end, beg_filename = result['deb_hour'].strip(), result['end_hour'].strip(), result['beg_day'].strip()
    end_filename = result['end_day'].strip()
    ip, login = result['ip'].strip(), result['login'].strip()
    size = int(result['size'].strip())
    denied = result['denied']
    if denied == False: denied = None
    else: denied = 'ok'
    ## formatage des valeurs non renseignées: vide ou '' devient None
    url = None
    result = [beg_filename, end_filename, beg, end, ip, login, url, denied, size]
    for indice, val in enumerate(result):
        if val in ['vide', '']:
            result[indice] = None
    logs, btns, num_btns = _get_paged_logs(zone, server_nb, name, result)
    return dict(logs=logs, btns=btns, num_btns=num_btns)

def get_page(zone, server_nb, name, params):
    """ renvoie les logs depuis une requete classique (bouton suivant et precedent """
    zone = zone_indices[zone]
    if 'beg_filename' in params and 'end_filename' in params:
        beg_filename, end_filename = params['beg_filename'][0], params['end_filename'][0]
    else:
        beg_filename, end_filename = None, None
    if 'beg' in params and 'end' in params:
        beg, end =params['beg'][0], params['end'][0]
    else:
        beg, end = None, None
    if 'ip' in params:
        ip = params['ip'][0]
    else:
        ip = None
    if 'login' in params:
        login = params['login'][0]
    else:
        login = None
    if 'page' in params:
        page = int(params['page'][0])
    else:
        page=1
    if 'size' in params:
        size = int(params['size'][0])
    else:
        size = 10
    if 'url' in params:
        url = params['url'][0]
    else:
        url = None
    if 'denied' in params:
        denied = params['denied'][0]
    else:
        denied = None
    params = [beg_filename, end_filename, beg, end, ip, login, url, denied, size]
    for indice, valeur in enumerate(params):
        if valeur in ['','None', 'vide']:
            params[indice] = None
    logs, page_btns, num_btns = _get_paged_logs(zone, server_nb, name, params, page)
    return dict(logs = logs, btns =page_btns, num_btns=num_btns)

#méthode qui renvoie les logs avec pagination
def _get_paged_logs(zone, server_nb, name, params, page=1):
    """ renvoie les logs selon les critères demandés avec système de pagination
        params dans l'ordre: beg_filename (premier jour), end_filename (dernier jour),
                                heure de debut, heure de fin, ip, login, url, denied, size
    """
    logs = _get_logs(zone, server_nb, name, params)
    size = params[-1]
    if len(logs) > size:
        max_index = size
        if page is not None:
            max_index = size * page
        min_index = max_index - size
        length = len(logs)
        logs = logs[min_index:max_index]
        btns, num_btns = _get_btns(zone, server_nb, name, params, page, length)
        return logs, btns, num_btns
    return logs, [], []

#méthode pour le parsing de log
def _get_logs(zone, server_nb, name, params):
    """ renvoie les logs selon les critères demandés
        params : dans l'ordre:beg_filename (premier jour), end_filename (dernier jour), heure de debut,
                                    heure de fin, ip, login, url, denied
    """
    beg_filename, end_filename, beg, end, ip, login, url, denied = params[:8]
    if beg_filename == None:
        log.err("Erreur: navigation_visit.py, la requête doit être plus ciblée.")
        raise Exception("Erreur : votre requête doit être plus ciblée.")
    elif end_filename == None:
        days = [beg_filename]
    else:
        all_logfilenames = file_listing.get_logs(zone)
        if all_logfilenames.index(beg_filename) < all_logfilenames.index(end_filename):
            log.err("Erreur: navigation_visit.py, le jour de début doit précéder le jour de fin.")
            raise Exception("Erreur : Le jour de début doit précéder le jour de fin.")
        days = all_logfilenames[all_logfilenames.index(end_filename):(all_logfilenames.index(beg_filename)+1)]
    logs = logparsing.get_logs(filenames=days, ip=ip,login=login, url=url, hours=(beg, end), denied=denied)
    return logs

#méthode renvoyant les boutons suivant et précédent
def _get_btns(zone, server_nb, name, params, page=1, length=10):
    """ renvoie la description des boutons de passage de page en page.
        on passe les params de recherche
        @page:numéro de page courant
        @length:nombre de résultat par page
    """
    beg_filename, end_filename, beg, end, ip, login, url, denied, size = params
    next = {'libelle': 'suivant >', 'icone':'', 'title':'',
            'href':tools.make_long_js_link(server_nb, name, balise='div_log_table_container',
                            page=page+1, beg_filename=beg_filename, end_filename=end_filename, beg=beg,
                            end=end, ip=ip, login=login, denied=denied, size=size, url=url)}
    prec = {'libelle': '< précédent', 'icone':'', 'title':'',
            'href':tools.make_long_js_link(server_nb, name, balise='div_log_table_container',
                            page=page-1, beg_filename=beg_filename, end_filename=end_filename, beg=beg,
                            end=end, ip=ip, login=login, denied=denied, size=size, url=url)}
    # calcul du nombre de page à afficher on affiche que 8 nombres donc on calcule un indice max et min
    # ex on affiche la page 8, on aura les liens 4 5 6 7 8 9 10 11 12
    num_page = int(length/float(size)-0.1)+1
    maxindex = min(((page-1)+5), num_page)
    minindex = max(((page-1)-4), 0)
    indices = list(range(num_page))
    num_btns = [{'libelle':str(num+1), 'icone':'', '_class':'amon_simple_link', 'title':'page %s'%(num+1),
                'href':tools.make_long_js_link(server_nb, name, balise='div_log_table_container',
                        page=num+1, beg_filename=beg_filename, end_filename=end_filename, beg=beg,
                        end=end, ip=ip, login=login, denied=denied, size=size, url=url)}for num in indices]
    num_btns[page-1]['href'] = '#'
    num_btns[page-1]['_class'] = 'amon_simple_active_link'
    result = num_btns[minindex:maxindex]
    if minindex != 0:
        a = num_btns[0]
        a['libelle'] += "  ..."
        result.insert(0,a)
    if maxindex<num_page:
        a = num_btns[num_page-1]
        a['libelle'] = "...   %s"%a['libelle']
        result.append(a)
    if page == 1 :
        return [next], result
    elif ((page) * size)>=length:
        return [prec], result
    else:
        return [prec, next], result
