#!/usr/bin/env python3

# Script de regénération du template tmpl/db.safesearch
# Ce script télécharge la liste de dommaine google
# et génère un template avec la liste des domaines supportés
# dans le dépôt git.
# usage : ./gen_safesearch_template.py

from urllib.request import urlopen
from sys import exit
from datetime import datetime

date = datetime.now().strftime("%Y%m%d%H")

contents = f"""; DO NOT EDIT! File autogenerated by gen_safesearch_template.py
$TTL 86400
@	SOA	%%{{nom_domaine_machine}}. root.%%{{nom_domaine_local}}. ( {date} 10800 3600 604800 600 )
	NS	%%{{nom_domaine_machine}}.

; Forced Safe Search zone and data
%if %%google_moderate == 'oui'
"""

with urlopen('https://www.google.com/supported_domains') as supported_domains:
    for domain in supported_domains.readlines():
        domain = domain.decode().strip()
        if not domain.startswith('.'):
            print(f'domaine incomprehensible {domain}')
            exit(1)
        contents += f'{domain[1:]}\t\tCNAME forcesafesearch.google.com.\n'
        contents += f'www{domain}\t\tCNAME forcesafesearch.google.com.\n'


contents += """%end if
"""
contents += """
%if %%youtube_moderate == 'oui'
www.youtube.com CNAME restrict.youtube.com.
m.youtube.com CNAME restrict.youtube.com.
youtubei.googleapis.com CNAME restrict.youtube.com.
youtube.googleapis.com CNAME restrict.youtube.com.
www.youtube-nocookie.com CNAME restrict.youtube.com.
%end if
"""
contents += """
%if %%bing_moderate == 'oui'
www.bing.com CNAME strict.bing.com.
bing.com CNAME strict.bing.com.
%end if
"""
contents += """
%if %%duckduckgo_moderate == 'oui'
duckduckgo.com CNAME safe.duckduckgo.com.
%end if
"""
contents += """
%if %%qwant_moderate == 'oui'
api.qwant.com CNAME safeapi.qwant.com.
%end if
"""

with open('tmpl/db.safesearch', 'w') as safesearch:
    safesearch.write(contents)
