/* globals window */
(function(ipaddr) {

  'use strict';

  var IPv4 = ipaddr.IPv4;

  if (typeof IPv4.prototype.toInt === 'function') printOverrideWarning('IPv4.toInt()');

  // Return a integer representation of the IPv4
  IPv4.prototype.toInt = function() {
    var acc=0;
    this.toByteArray().forEach(function(octet) {
      acc <<= 8;
      acc += octet;
    });
    return (acc >>> 0);
  };


  if (typeof IPv4.prototype.above === 'function') printOverrideWarning('IPv4.above()');

  // Return true if the IPv4 is above the given adress
  IPv4.prototype.above = function(ip, strict) {

    strict = strict === undefined ? strict : false;

    if (typeof ip === 'string') ip = ipaddr.parse(ip);

    var ipVal = ip.toInt();
    var thisVal = this.toInt();

    return strict ? thisVal > ipVal : thisVal >= ipVal;

  };

  if (typeof IPv4.prototype.below === 'function') printOverrideWarning('IPv4.below()');

  // Return true if the IPv4 is below the given adress
  IPv4.prototype.below = function(ip, strict) {

    strict = strict === undefined ? strict : false;

    if (typeof ip === 'string') ip = ipaddr.parse(ip);

    var ipVal = ip.toInt();
    var thisVal = this.toInt();

    return strict ? thisVal < ipVal : thisVal <= ipVal;

  };

  if (typeof IPv4.prototype.within === 'function') printOverrideWarning('IPv4.within()');

  // Return true if the IPv4 is between the given addresses
  IPv4.prototype.within = function(low, high, strict) {
    return this.above(low, strict) && this.below(high, strict);
  };

  function printOverrideWarning(method) {
    /* eslint-disable no-console */
    console.warn('Overrriding ' + method + ' method');
    /* eslint-enable no-console */
  }

}(window.ipaddr));
