# -*- mode: python; coding: utf-8 -*-

"""Test L{pyeole.debsums}"""

def test_import():
    """
    Test the import of the module

    >>> from pyeole import debsums
    >>> from pyeole.debsums import EoleDebsumsReport
    >>> from pyeole.debsums import NoEoleDebsumsReportError
    >>> from pyeole.debsums import EoleDebsumsReportParseError
    """

def test_create_object():
    """
    Test the creation of an object

    Methods tested:
        - L{pyeole.debsums.EoleDebsumsReport.__init__}
        - L{pyeole.debsums.EoleDebsumsReport._parse}

    >>> from pyeole import debsums
    >>> r = debsums.EoleDebsumsReport("pkg1: file1\\npkg2: file2\\npkg1: file3")
    >>> type(r)
    <class 'pyeole.debsums.EoleDebsumsReport'>
    >>> r = debsums.EoleDebsumsReport("pkg1:/invalid")
    Traceback (most recent call last):
    ...
    EoleDebsumsReportParseError: Error parsing line 'pkg1:/invalid'
    """

def test_getitem():
    """
    Test accessing packages list by []

    Methods tested:
        - L{pyeole.debsums.EoleDebsumsReport.__getitem__}

    >>> from pyeole import debsums
    >>> r = debsums.EoleDebsumsReport("pkg1: file1\\npkg2: file2\\npkg1: file3")
    >>> f = r['pkg1']
    >>> 'file1' in f
    True
    >>> 'file3' in f
    True
    >>> 'inexistant' in f
    False
    """

def test_items():
    """
    Test listing all items in an EoleDebsumsReport

    Methods tested:
        - L{pyeole.debsums.EoleDebsumsReport.items}

    >>> from pyeole import debsums
    >>> r = debsums.EoleDebsumsReport('pkg1: file1\\npkg2: file2\\npkg1: file3')
    >>> i = r.items()
    >>> ('pkg2', set(['file2'])) in i
    True
    >>> ('pkg1', set(['file3', 'file1'])) in i
    True
    >>> ('inexistantpkg', set(['inexistantfile'])) in i
    False
    """

def test_iterator():
    """
    Test iterating on all items

    Methods tested:
        - L{pyeole.debsums.EoleDebsumsReport.items}

    >>> from pyeole import debsums
    >>> r = debsums.EoleDebsumsReport("pkg1: file1\\npkg2: file2\\npkg1: file3")
    >>> t = r.iteritems()
    >>> p = t.next()
    >>> p in [('pkg2', set(['file2'])), ('pkg1', set(['file3', 'file1']))]
    True
    >>> p = t.next()
    >>> p in [('pkg2', set(['file2'])), ('pkg1', set(['file3', 'file1']))]
    True
    >>> p = t.next()
    Traceback (most recent call last):
    ...
    StopIteration
    """
