# -*- coding: utf-8 -*-
###########################################################################
# Eole - 2014
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################
"""
ihm utilities
"""
import time
from .util import log

def _time_format(t01, t02):
    mytime = time.strftime('%j %H:%M:%S', time.gmtime(t02-t01)).split(' ')
    return "{0} jours {1}".format(int(mytime[0])-1, mytime[1])

def print_time(_type, times):
    """
    Affichage des temps de traitement

    :param times: tableau des temps intermédiaires
    """
    times.append(time.time())
    last = _time_format(times[-2], times[-1])
    full = _time_format(times[0], times[-1])
    log.info("\n* Temps de traitement des {0} : {1}\n".format(_type,
        last))
    log.info("** Temps écoulé depuis le début {0}\n".format(full))
    return times
