#-*-coding:utf-8*-*
from pyeole.process import system_out

NGINX_TEST = """nginx: the configuration file /etc/nginx/nginx.conf syntax is ok
nginx: configuration file /etc/nginx/nginx.conf test is successful
"""

def test_nginx():
    """
    Vérifie que la configuration nginx ne signale pas de problème
    """
    assert system_out(['nginx', '-t'])[2] == NGINX_TEST

def test_disabled_services():
    """
    Vérifie que certains services non désirés sont bien désactivés (#17354)
    """
    assert system_out(['systemctl', 'is-enabled', 'apt-daily.timer'])[1].rstrip() == "masked"
    assert system_out(['systemctl', 'is-enabled', 'apt-daily.service'])[1].rstrip() == "masked"
