#-*-coding:utf-8*-*
from os.path import isfile, join
from creole.loader import creole_loader
from creole.lxml_parser import parse_xml_file
from creole.dtd_parser import parse_dtd
from creole.config import dtdfilename

def test_timezone():
    """
    Vérifie la disponibilité des configurations
    proposées pour la timezone
    """
    loader = creole_loader()
    var = loader.unwrap_from_path('creole.general.time_zone')
    for tzone in var.impl_get_information('proposed_value'):
        assert isfile(join("/usr/share/zoneinfo", tzone))

def test_nut_ups_driver():
    """
    Vérifie la disponibilité des drivers nut proposés
    """
    dico = parse_xml_file('/usr/share/eole/creole/dicos/20_nut.xml', parse_dtd(dtdfilename))
    fonction = dico['checks']['nut_ups_driver'][0][1][0]['value']
    from creole import eosfunc
    default_drivers = eval('[{0}]'.format(fonction.split('[')[1].split(']')[0]))
    calculated_drivers = eval(fonction)
    print default_drivers
    print calculated_drivers
    assert default_drivers == calculated_drivers

