. /usr/lib/eole/ihm.sh

TestFile()
{
    [ -f "$1" ] && return 0
    EchoRouge "* Erreur : fichier $1 absent"
    echo
    return 1
}

TestDir()
{
    [ -d "$1" ] && return 0
    EchoRouge "* Erreur : répertoire $1 absent"
    echo
    return 1
}

#
# @NAME : TestCreoled
# @AIM  : Tester si Creoled fonctionne
# @PARAMS : None
#
function TestCreoled()
{
    var_name='eole_version'
    if ! CreoleGet ${var_name} > /dev/null
    then
        EchoRouge "* Erreur : Creoled n'est pas actif"
        return 1
    fi
}

function wait_true_retcode()
{
# teste une commande en boucle jusqu'à ret_code=0
# ou $tries boucles
# exemple : wait_true_retcode "texte" "commande param1 param2"
    tries=120
    ret_code=1
    i=0
    echo -n $1
    until [ $ret_code -eq 0 ] || [ $i -ge $tries ]
    do
        i=`expr $i + 1`
        sleep 1
        eval $2
        ret_code=$?
        echo -n "."
    done
    echo
    if [ $i -eq $tries ]
    then
        EchoRouge "L'action '$1' n'a pas aboutie."
        exit $ret_code
    fi
}

function only_root()
{
    if [ $(id -u) -ne 0 ]
    then
        echo "$0 ne peut être exécuté qu'en root"
        exit 1
    fi
}

InstallSSLFiles()
{
    # Install SSL directories and files for a service #23694
    # $1 : Service name
    # $2 : user running the service
    # $3 : group running the service
    # $4 : path where to copy files
    # $5 : container running the service

    if [ -n "$5" ]; then
        container_path="$(CreoleGet container_path_$5)"
    else
        container_path=""
    fi
    grep -q -e "^${2}:" ${container_path}/etc/shadow
    if [ $? -eq 1 ]; then
        EchoRouge "L'utilisateur $2 n'existe pas !!!"
        return 1
    fi
    grep -q -e "^${3}:" ${container_path}/etc/group
    if [ $? -eq 1 ]; then
        EchoRouge "Le groupe $3 n'existe pas !!!"
        return 1
    fi
    cert_dir="${container_path}$4/certs"
    privkey_dir="${container_path}$4/private"
    [ ! -d "$4" ] && mkdir -p $4
    [ ! -d "$cert_dir" ] && mkdir -p $cert_dir
    chmod 0755 $cert_dir
    [ ! -d "$privkey_dir" ] && mkdir -p $privkey_dir
    chmod 0700 $privkey_dir
    server_cert="$(CreoleGet server_cert)"
    server_key="$(CreoleGet server_key)"
    dest_cert_file="${cert_dir}/$1.crt"
    dest_privkey_file="${privkey_dir}/$1.key"
    cp $server_cert $dest_cert_file
    chmod 0644 $dest_cert_file
    cp $server_key $dest_privkey_file
    chmod 0600 $dest_privkey_file
    CreoleRun "chown -R $2:$3 $4" $5
}

# function copied from :
# https://stackoverflow.com/questions/20762575/explanation-of-convertor-of-cidr-to-netmask-in-linux-shell-netmask2cdir-and-cdir
mask2cdr()
{
   # Assumes there's no "255." after a non-255 byte in the mask
   local x=${1##*255.}
   set -- 0^^^128^192^224^240^248^252^254^ $(( (${#1} - ${#x})*2 )) ${x%%.*}
   x=${1%%$3*}
   echo $(( $2 + (${#x}/4) ))
}

function enable_service()
{
    svc="$1"
    container="$2"
    if ! CreoleRun "systemctl is-enabled $svc &>/dev/null" $container;then
        echo "* Activation du service $svc"
        CreoleRun "systemctl unmask $svc" $container
        CreoleRun "systemctl enable $svc" $container
    fi
    CreoleRun "systemctl restart $svc" dhcp
}

function disable_service()
{
    svc="$1"
    container="$2"
    if CreoleRun "systemctl is-enabled $svc &>/dev/null" $container;then
        echo "* Désactivation du service $svc"
        CreoleRun "systemctl stop $svc" $container
        CreoleRun "systemctl disable $svc" $container
    fi
}
