#! /usr/bin/env python
# -*- coding: UTF-8 -*-
"""
Test des patches pour diagnose
réutilisation du code de zephir-client
"""
from glob import glob
from os.path import basename, join
from pyeole.ansiprint import print_red, print_green
from creole.config import patch_dir
from zephir.monitor.agents import patches

patchs = glob(join(patch_dir, '*.patch'))
patchs.extend(glob(join(patch_dir, 'variante', '*.patch')))
err = []
for patch in patchs:
    verif = patches.verify_patch(patch).values()
    if len(verif) > 0 and len(verif[0]) > 0:
        err.append(basename(patch))
if len(err) != 0:
    print_red('Erreur')
    print "fichiers : %s" % (", ".join(err),)
else:
    print_green('Ok')
