#!/usr/bin/env python
# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2009
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# http://eole.orion.education.fr - eole@ac-dijon.fr
#
# Licence CeCill
# cf:  http://www.cecill.info/licences.fr.html
###########################################################################

import sys
import socket
from os.path import isfile
from os import system, stat
from pyeole.httprequest import HTTPRequest
from creole.config import configeol
from creole.client import CreoleClient

client = CreoleClient()

# adresse IP et port du serveur d'enregistrement
server = "http://194.167.18.21/apps/AutoDiag/index.n/diagnose"
md5file = "/etc/eole/.server.MD5"
server_type_file = "/etc/eole/.server.type"
eole_module = client.get_creole('eole_module')
eole_version = client.get_creole('eole_version')
eole_release = client.get_creole('eole_release')
module = "%s-%s" % (eole_module, eole_version)

def get_server_type():
    """Lookup type of server: physical or virtual"""
    if not isfile(server_type_file) or stat(server_type_file).st_size == 0:
        system("systemd-detect-virt --vm > %s" % server_type_file)
        with open(server_type_file, 'r+') as fh:
            server_type = fh.read().strip()
            if not server_type or server_type == 'none':
                fh.seek(0)
                fh.truncate(0)
                fh.write('physical\n')
    with open(server_type_file, 'r') as fh:
        return fh.read().strip()

def get_md5():
    """ calcul de l'identifiant md5 """
    if not isfile(md5file) or stat(md5file).st_size == 0:
        system("md5sum %s | awk '{print $1}' > %s" % (configeol, md5file))
    fp = file(md5file)
    return (fp.read().split()[0])

def get_proxy():
    """ récupération du proxy à utiliser """
    if client.get_creole('activer_proxy_client') == 'oui':
        return "http://{0}:{1}".format(
                client.get_creole('proxy_client_adresse'),
                client.get_creole('proxy_client_port'))
    return ''

if __name__ == "__main__":
    id5 = get_md5()
    server_type = get_server_type()
    rne = client.get_creole('numero_etab')
    data = {"ID5":id5,
            "module":module,
            "rne":rne,
            "dep":rne[0:3],
            "eole_module": eole_module,
            "eole_version": eole_version,
            "eole_release": eole_release,
            "server_type": server_type}
    socket.setdefaulttimeout(5)
    proxy = get_proxy()
    if proxy != '':
        # essai avec proxy
        try:
            req = HTTPRequest(proxy={'http':proxy})
            req.request(server, post_datas=data)
        except:
            pass
        else:
            sys.exit(0)
    # essai sans proxy
    try:
        req = HTTPRequest()
        req.request(server, post_datas=data)
    except:
        sys.exit(1)
    else:
        sys.exit(0)
