# -*- coding: UTF-8 -*-
"""
utilitaires créole
"""

import sys
from .error import NoneError, OutOfRange
from .config import charset
from pyeole.ansiprint import *
import time, hashlib, random, unicodedata
import shlex
from subprocess import Popen, PIPE


if sys.version_info[0] >= 3:
    unicode = str


# définition des classes d'adresse IP existantes
classes = {
    u'128.0.0.0' : u'1'
    , u'192.0.0.0' : u'2'
    , u'224.0.0.0' : u'3'
    , u'240.0.0.0' : u'4'
    , u'248.0.0.0' : u'5'
    , u'252.0.0.0' : u'6'
    , u'254.0.0.0' : u'7'
    , u'255.0.0.0' : u'8'
    , u'255.128.0.0' : u'9'
    , u'255.192.0.0' : u'10'
    , u'255.224.0.0' : u'11'
    , u'255.240.0.0' : u'12'
    , u'255.248.0.0' : u'13'
    , u'255.252.0.0' : u'14'
    , u'255.254.0.0' : u'15'
    , u'255.255.0.0' : u'16'
    , u'255.255.128.0' : u'17'
    , u'255.255.192.0' : u'18'
    , u'255.255.224.0' : u'19'
    , u'255.255.240.0' : u'20'
    , u'255.255.248.0' : u'21'
    , u'255.255.252.0' : u'22'
    , u'255.255.254.0' : u'23'
    , u'255.255.255.0' : u'24'
    , u'255.255.255.128' : u'25'
    , u'255.255.255.192' : u'26'
    , u'255.255.255.224' : u'27'
    , u'255.255.255.240' : u'28'
    , u'255.255.255.248' : u'29'
    , u'255.255.255.252' : u'30'
    , u'255.255.255.254' : u'31'
    , u'255.255.255.255' : u'32'
}

def string_to_bool(string):
    """
    Transforme les chaines 'True' ou 'False' en valeurs booléennes
    """
    if string == "":
        raise ValueError('empty string')
    result = eval(string)
    if result not in [True, False]:
        raise TypeError("""string must be like 'True' or 'False' """)
    else: return result


def get_text_node(node):
    """
    @param node: node minidom contenant du texte
    Utilitaire minidom permettant de récupérer le texte d'un node texte
    """
    texte = ""
    nodelist = node.childNodes
    for textnode in nodelist:
        if textnode.nodeType == textnode.TEXT_NODE:
            texte = texte + textnode.data
    return texte


# utilitaires pour la
# ligne de commande

def raw(text):
    """
    Question en ligne de commande : permet de repérer si l'utilisateur a renvoyé quelque chose

    @param text: le libellé de message
    @return: la variable demandée
    """
    var = raw_input(text + " : ")
    if var:
        return var
    else:
        raise NoneError


def stringify(string):
    """
    Encodage des chaînes avec le charset local
    """
    try:
        return string.encode(charset)
    except:
        return string

def encode_list(_list):
    """ encode une liste en utf-8 si les éléments sont de type dico ou str ou liste, unicode"""
    encoded_list = []
    for element in _list:
        if type(element) == str:
            encoded_list.append(encode_str(element))
        elif type(element) == dict:
            encoded_list.append(encode_dico(element))
        elif type(element) == list:
            encoded_list.append(encode_list(element))
        elif type(element) == unicode:
            encoded_list.append(encode_str(element))
        else:
            encoded_list.append(element)
    return encoded_list

def encode_str(string):
    """ encode une string ou un unicode en utf8 """
    try:
        string = string.encode(charset)
    except:
        pass
    return string

def encode_dico(dico):
    """ encode un dico en utf8 dans le cas ou les valeurs soient de type dico, liste, str, unicode """
    for key in dico.keys():
        if type(dico[key]) == str:
            dico[key] = encode_str(dico[key])
        elif type(dico[key]) == unicode:
            dico[key] = encode_str(dico[key])
        elif type(dico[key]) == dict:
            dico[key] = encode_dico(dico[key])
        elif type(dico[key]) == list:
            dico[key] = encode_list(dico[key])
    return dico


def select_list(selection):
    """
    Utilitaire de construction d'une sélection en ligne de commande
    @param selection : liste
    @return :  l'identifiant sélectionné (entier)
    """
    # affichage de la liste (ordonnée)
    for i in selection:
        print(selection.index(i) , ':', stringify(i))
        # print selection.index(i) , ':', i[0]

    # recuperation du numero
    try:
        number = int(raw(stringify(_("Choose a number in the list"))))
    except:
        raise OutOfRange
    if number not in range(len(selection)):
        raise OutOfRange
    return number

def gen_random(length=None):
    """
        length: longueur de la chaine aléatoire attendu
    """
    random_id = str(time.time()).split('.')[0]
    if sys.version_info[0] >= 3:
        random_str = hashlib.sha224('{}/{}'.format(random_id, str(random.randrange(2**100))).encode('utf-8')).hexdigest()
        return random_str[:length]
    else:
        random_str = hashlib.sha224('{}/{}'.format(random_id, random.randrange(2**100))).hexdigest()
        return unicode(random_str[:length], 'utf8')

def normalize_family(family_name, check_name=True):
    """
    il ne faut pas d'espace, d'accent, de majuscule, de tiré, ...
    dans le nom des familles
    """
    f = unicode(family_name)
    f = f.replace('-', '_')
    #f = f.replace(u'é', 'e')
    #f = f.replace(u'è', 'e')
    nfkd_form = unicodedata.normalize('NFKD', f)
    f = u"".join([c for c in nfkd_form if not unicodedata.combining(c)])
    f = f.replace(' ', '_')
    f = f.lower()
    try:
        int(f[0])
    except ValueError:
        pass
    else:
        raise ValueError(u'Le nom de la famille ne doit pas commencer par un chiffre : {0}'.format(f))
    if check_name and f.lower() in ['containers']:
        raise ValueError(u'nom de la famille interdit {0}'.format(f))
    return f

def run_bash_function(library_path, function_name, params):
    params = shlex.split('"source %s; %s %s"' % (library_path, function_name, params))
    cmdline = ['bash', '-c'] + params
    p = Popen(cmdline, stdout=PIPE, stderr=PIPE)
    stdout, stderr = p.communicate()
    if p.returncode != 0:
        print(stdout.rstrip())
        return 1
    return 0
