
Ext.namespace("ARV");

var delete_btn = function(url, deleteid, fireevent, store){
	obj = {url: url, deleteid: deleteid, fireevent: fireevent, store: store};
    function confirm_delete(btn, text, opt){
        if (btn == 'yes') {
            Ext.Ajax.request({
               url: url,
               success: onDelete,
               params: {deleteid: deleteid}
            });

        };
    };
    function onDelete() {
        if (fireevent != null) {
            ARV.observable.fireEvent(fireevent)
        }
        if (store != null) {
            store.load()
        }
    };
    Ext.MessageBox.show({
       title: Ext.i18n.confirm_delete_title,
       msg: Ext.i18n.confirm_delete,
       buttons: Ext.MessageBox.YESNO,
       fn: confirm_delete,
       animEl: 'mb4',
       icon: Ext.MessageBox.QUESTION,
	   scope: obj
   });
};

var error_msg = function(msg) {
    Ext.Msg.show({
        title: Ext.i18n.error_title,
        msg: msg,
        buttons: Ext.Msg.OK,
        icon: Ext.MessageBox.ERROR
    });
};

var ok_msg = function(title, msg) {
    Ext.Msg.show({
        title: title,
        msg: msg,
        buttons: Ext.Msg.OK,
        icon: Ext.MessageBox.OK
    });
};

var info_msg = function(msg) {
    Ext.Msg.show({
        title: Ext.i18n.info_title,
        msg: msg,
        buttons: Ext.Msg.INFO,
        icon: Ext.MessageBox.INFO
    });
};

var create_new_store = function (){
    return new Ext.data.Store({
        reader: new Ext.data.JsonReader({
            root :'data',
            successProperty: 'success'
        })
    });
};

ARV.PopupWindow = Ext.extend(Ext.Window, {
    height: 300,
    width: 300,
    layout: 'fit',
    closable: false,
    resizable: false,
    modal: true,
    border: false,
});

Ext.reg('sphynxpopupwindow', ARV.PopupWindow);

ARV.ComboBox = Ext.extend(Ext.form.ComboBox, {
    initComponent: function() {
        combo = this;
        if (this.displayField == null) {
            console.log('need displayField')
        };
        if (this.url == null) {
            console.log('need url')
        };
        if (this.record == null) {
            console.log('need record')
        };
        if (this.listen == null) {
            this.listen = {}
        };
        if (this.baseParams == null) {
            this.baseParams = {}
        };
        if (this.autoLoad == null) {
            this.autoLoad = true
        };
        if (this.width == null) {
            this.width = 150
        };
        if (this.hiddenName == null) {
            this.hiddenName = 'id'
        };
        var config = {
            width: this.width,
            hiddenName: this.hiddenName,
            store: new Ext.data.Store({
                reader: new Ext.data.JsonReader({
                    root :'data',
                    successProperty: 'success',
                }, this.record
                ),
                baseParams: this.baseParams,
                autoLoad: this.autoLoad,
                url: this.url,
                listeners: this.listen
            }),
            valueField: 'id',
            displayField: this.displayField,
            forceSelection: true,
            mode: 'local',
            typeAhead: true,
            allowBlank: false,
            triggerAction: 'all',
            selectOnFocus: true,
            editable: false
        }
        Ext.apply(this, config);
        ARV.ComboBox.superclass.initComponent.call(this)
    },
});

Ext.reg('arvcombo', ARV.ComboBox);
