/*
 *
 *
 */

Ext.namespace("ARV");

ARV.treetmpledge = (function() {
    /*
     * Private
     */
    var connect = null;

    var cacert = new Ext.Panel({
        title: Ext.i18n.cacert,
        layout: 'fit',
        width: 400,
        html: "&nbsp;"
    });

    var tmplnode1 = new Ext.Panel({
        title: Ext.i18n.tmplnode1,
        layout: 'fit',
        width: 200,
        html: "&nbsp;"
    });

    var tmplnode2 = new Ext.Panel({
        title: Ext.i18n.tmplnode2,
        layout: 'fit',
        width: 200,
        html: "&nbsp;"
    });

    var ttestore = new Ext.data.Store({
        reader: new Ext.data.JsonReader({
            root :'data',
            successProperty: 'success',
            },[
                {name: 'id'},
                {name: 'tmplvertexname'},
                {name: 'tmplvertex1'},
                {name: 'tmplvertex1id'},
                {name: 'tmplvertex2'},
                {name: 'tmplvertex2id'},
            ]),
            url: 'arv/get_tmpl_edges'
    });

    columns = [
        {id: 'tmplvertexname', header: Ext.i18n.tmplvertex_name, sortable: true, dataIndex: 'tmplvertexname', width: '133px'},
        {id: 'tmplvertex1', header: Ext.i18n.tmplvertex1, sortable: true, dataIndex: 'tmplvertex1', width: '133px'},
        {header: 'tmplvertex1id', sortable: true, dataIndex: 'tmplvertex1id', hidden: true},
        {id: 'tmplvertex2', header: Ext.i18n.tmplvertex2, sortable: true, dataIndex: 'tmplvertex2', width: '133px'},
        {header: 'tmplvertex2id', sortable: true, dataIndex: 'tmplvertex2id', hidden: true},
        {header: 'id', sortable: true, dataIndex: 'id', hidden: true},
    ];

    var tree = new ARV.GridPanel({
        store: ttestore,
        columns: columns,
        layout: 'fit',
        forcefit: false,
        flex: 3,
        title: Ext.i18n.tmpledges,
        deleteUrl: 'arv/del_tmpl_edge',
        btnAddEvent: 'treetmpledgeadd',
        btnModEvent: 'treetmpledgemod',
        btnDelEvent: 'treetmpledgechanged'
    });

    var tmplvertexstore = new Ext.data.Store({
        reader: new Ext.data.JsonReader({
            root :'data',
            successProperty: 'success',
            },[
                {name: 'id'},
                {name: 'tmplnode'},
                {name: 'tmplnodeid'},
                {name: 'tmplvertexname'},
                {name: 'tmplvertexmimetype'},
                {name: 'tmplvertexmodule'},
                {name: 'tmplvertexip1'},
                {name: 'tmplvertexip2'}
            ]),
            url: 'arv/get_tmpl_vertices'
    });

    columntmplvertex = [
        {header: 'id', sortable: true, dataIndex: 'id', hidden: true},
        {id: 'tmplvertexname', header: Ext.i18n.tmplvertex_name, sortable: true, dataIndex: 'tmplvertexname', width: '133px'},
        {id: 'tmplvertexmimetype', header: Ext.i18n.tmplvertex_mimetype, sortable: true, dataIndex: 'tmplvertexmimetype', width: '133px'},
        {id: 'tmplnode', header: Ext.i18n.tmplnode, sortable: true, dataIndex: 'tmplnode', width: '133px'},
        {header: 'tmplnodeid', sortable: true, dataIndex: 'tmplnodeid', hidden: true},
        {header: 'tmplvertexmodule', sortable: true, dataIndex: 'tmplvertexmodule', hidden: true},
        {header: 'tmplvertexip1', sortable: true, dataIndex: 'tmplvertexip1', hidden: true},
        {header: 'tmplvertexip2', sortable: true, dataIndex: 'tmplvertexip2', hidden: true}
    ];

    var tmplvertextree = new ARV.GridPanel({
        store: tmplvertexstore,
        columns: columntmplvertex,
        layout: 'fit',
        forcefit: false,
        flex: 2,
        width: 400,
        title: Ext.i18n.tmplvertex_title,
        deleteUrl: 'arv/del_tmpl_vertex',
        btnModEvent: 'treetmplvertexmod',
        btnDelEvent: 'tmplvertexchanged'
    });

    /*
     * Public
     */

    return {
        removeAll: function(){
            ttestore.removeAll();
        },
        load: function(tmplconnectid, ca_cert, tmplnodea, tmplnodeb) {
            connect = tmplconnectid;
            ttestore.removeAll();
            if (tmplconnectid != null) {
                ttestore.baseParams={id: tmplconnectid};
                ttestore.load();
                cacert.body.update(ca_cert);
                tmplnode1.body.update(tmplnodea);
                tmplnode2.body.update(tmplnodeb);
            } else {
                if (cacert.body) {
                    cacert.body.update('&nbsp;');
                    tmplnode1.body.update('&nbsp;');
                    tmplnode2.body.update('&nbsp;');
                }
            }
        },
        get: function() {
            return tree;
        },
        getCaCert: function() {
            return cacert;
        },
        getTmplNode1: function() {
            return tmplnode1;
        },
        getTmplNode2: function() {
            return tmplnode2;
        },
        getSelectedRecord: function() {
            if (tree.getSelectionModel().hasSelection()) {
                return tree.getSelectionModel().getSelected();
            } else {
                return null
            }
        },
        removeTmplVertexAll: function(){
            tmplvertexstore.removeAll();
        },
        loadTmplVertex: function() {
            tmplvertexstore.removeAll();
            tmplvertexstore.load();
        },
        getTmplVertex: function() {
            return tmplvertextree;
        },
        getSelectedRecordTmplVertex: function() {
            if (tmplvertextree.getSelectionModel().hasSelection()) {
                return tmplvertextree.getSelectionModel().getSelected();
            } else {
                return null
            }
        }

    };
})();
