/*
 *
 *
 */

Ext.namespace("ARV");

ARV.modextip = (function() {
    /*
     * Public
     */

    var modextip_store = new Ext.data.Store({
        reader: new Ext.data.JsonReader({
            root :'data',
            successProperty: 'success',
        },[
            {name : 'id'},
            {name : 'extr'}
        ]),
        url: 'arv/get_extr',
    });
    columns = [
        {header: Ext.i18n.extrip_header, sortable: true,
                dataIndex: 'extr'},
        {header: 'ID', sortable: true, dataIndex: 'id', hidden: true}
    ];
    var cardcontent = new ARV.GridPanel({
        store: modextip_store,
        columns: columns,
        deleteUrl: 'arv/del_extip',
        btnAddEvent: 'extripadd',
        btnModEvent: 'extripmod',
        btnDelEvent: 'extripchanged'
    });
    return {
        load: function(node) {
            modextip_store.removeAll();
            modextip_store.baseParams={node: node};
            modextip_store.load();
        },
        openWindow: function(node){
            modextip_store.baseParams={node: node};
            modextip_store.load();

            var winextrip = new ARV.PopupWindow({
                title: Ext.i18n.extrip_title,
                items: [cardcontent],
                bbar: ['->', {
                    text: Ext.i18n.exit,
                    handler: function(){
                        //ARV.observable.fireEvent('closemodifyextrip');
                        winextrip.hide()
                    }
                }]
            }).show();
        },
        openIPWindow: function(node_id, fireevent) {
            extip = new Ext.FormPanel({
                labelWidth :80,
                frame :true,
                bodyStyle :'padding:5px;',
                defaultType :'textfield',
                monitorValid :true,
                title: Ext.i18n.addextremity_title,

                items : [{
                    fieldLabel: Ext.i18n.addextremity_pub_ip,
                    id: 'pub_ip',
                    name:'pub_ip',
                    allowBlank: false
                }, {
                    fieldLabel: Ext.i18n.addextremity_priv_ip,
                    id: 'priv_ip',
                    name: 'priv_ip',
                    allowBlank: true
                }],

                buttons: [{
                    text: Ext.i18n.save,
                    formBind :true,
                    handler: function() {
                        extip.getForm().submit({
                            url: 'arv/add_extremity',
                            params: {
                                id: node_id,
                            },
                            success: function(){
                                extip_win.destroy();
                                ARV.observable.fireEvent(fireevent);
                            }
                        })
                    },
                    scope: this
                }, '-', {
                    text: Ext.i18n.cancel,
                    handler: function(btn, ev) {
                        extip_win.destroy()
                    },
                    scope: this
                }]
            });

            var response_success = function(response, options){
                //load Zéphir value for this node
                data = Ext.util.JSON.decode(response.responseText).data;
                if (data['pub_ip'] != '') {
                    Ext.getCmp('pub_ip').setValue(data['pub_ip']);
                };
                if (data['priv_ip'] != '') {
                    Ext.getCmp('priv_ip').setValue(data['priv_ip']);
                };
            };

            Ext.Ajax.request({
                url: 'arv/get_extr',
                params: {
                    node: node_id,
                    new: 'true'
                },
                success: response_success
            });

            extip_win = new ARV.PopupWindow({
                //FIXME
                title: Ext.i18n.external_ip,
                width: 300,
                height: 150,
                items: [extip]
            }).show();
        },
        openModIPWindow: function(extr_id, fireevent) {
            extip = new Ext.FormPanel({
                labelWidth :80,
                frame :true,
                bodyStyle :'padding:5px;',
                defaultType :'textfield',
                monitorValid :true,
                title: Ext.i18n.modextremity_title,


                items : [{
                    fieldLabel: Ext.i18n.addextremity_pub_ip,
                    id: 'pub_ip',
                    name:'pub_ip',
                    allowBlank: false
                }, {
                    fieldLabel: Ext.i18n.addextremity_priv_ip,
                    id: 'priv_ip',
                    name: 'priv_ip',
                    allowBlank: true
                }],

                buttons: [{
                    text: Ext.i18n.ok,
                    formBind :true,
                    handler: function() {
                        extip.getForm().submit({
                            url: 'arv/mod_extremity',
                            params: {
                                id: extr_id,
                            },
                            success: function(){
                                extip_win.destroy();
                                ARV.observable.fireEvent(fireevent);
                            }
                        })
                    },
                    scope: this
                }, '-', {
                    text: Ext.i18n.cancel,
                    handler: function(btn, ev) {
                        extip_win.destroy()
                    },
                    scope: this
                }]
            });
            var response_success = function(response, options){
                //load Zéphir value for this node
                data = Ext.util.JSON.decode(response.responseText).data;
                if (data['pub_ip'] != '') {
                    Ext.getCmp('pub_ip').setValue(data['pub_ip']);
                };
                if (data['priv_ip'] != '') {
                    Ext.getCmp('priv_ip').setValue(data['priv_ip']);
                };
            };

            Ext.Ajax.request({
                url: 'arv/get_extr',
                params: {
                    extrip: extr_id
                },
                success: response_success
            });

            extip_win = new ARV.PopupWindow({
                //FIXME
                title: Ext.i18n.external_ip,
                width: 300,
                height: 150,
                items: [extip]
            }).show();

        },
        getSelectedId: function() {
            if (cardcontent.getSelectionModel().hasSelection()) {
                return cardcontent.getSelectionModel().getSelected().get('id');
            } else {
                return null
            }
        }
    }
})();

// vim: ts=4 sw=4 expandtab

