/*
 *
 *
 */

Ext.namespace("ARV");

ARV.addnode1 = (function() {
    /*
     * Public
     */

    return {
        //modid est utilisé si on modifie
        openWindow: function(modid, moduai, modname, modidzephir, modmimetype){
            Ext.apply(Ext.form.VTypes, {
                IPAddress:  function(v) {
                    s = v.split('| ')
                    for (var i = 0; i < s.length; i++) {
                        ret = /^\d{1,4}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/.test(s[i]);
                        if (ret == false) {
                            return ret
                        }
                    }
                    return ret
                },
                IPAddressText: 'Must be a numeric IP address',
                IPAddressMask: /[\d\.]/i
            });
            var ipeditor = new Ext.grid.GridEditor(
                new Ext.form.TextField({vtype: 'IPAddress'}), {}
            );
            var property_store = new Ext.data.JsonStore({
                url: 'arv/get_tmpl_vertices',
                root: 'data',
                fields: [
                    {name: 'id'},
                    {name: 'tmplvertex'},
                    {name: 'mimetype'},
                    {name: 'id_zephir'},
                    {name: 'ip1'},
                    {name: 'ip2'}
                ],
            });
            var zephir_store = new Ext.data.Store({
                reader: new Ext.data.JsonReader({
                    root: 'data',
                    successProperty: 'success',
                },[
                    {name : 'uai'},
                    {name : 'libelle'},
                    {name : 'id_zephir'},
                    {name : 'eole_version'},
                    {name : 'mimetype'}
                ]),
                url: 'arv/get_zephir_etabs'
            });
            
            var cardcontent = [{
                id: 'card-0',
                xtype: 'form',
                border: false,
                //layout: 'fit',
                items: [{
                    xtype: "radio",
                    checked: true,
                    fieldLabel: Ext.i18n.addnode1_zephir,
                    name: "node_method",
                    id: "node_zephir",
                    inputValue: 'node_zephir'
                },{
                    xtype: "radio",
                    fieldLabel: Ext.i18n.addnode1_manually,
                    name: "node_method",
                    id: 'node_manually',
                    inputValue: 'node_manually'
                }],
            }, {
                //Si on est en manuelle
                id: 'card-1',
                xtype: 'form',
                border: false,
                //layout: 'fit',
                items: [{
                    xtype: "textfield",
                    fieldLabel: Ext.i18n.uai,
                    width: 150,
                    name: 'uai',
                    value: moduai
                },{
                    xtype: "textfield",
                    fieldLabel: Ext.i18n.addnode_name,
                    width: 150,
                    id: 'nodename',
                    name: 'name',
                    value: modname,
                    allowBlank:false
                },{
                    xtype: "textfield",
                    fieldLabel: Ext.i18n.id_zephir,
                    width: 150,
                    id: 'id_zephir',
                    name: 'id_zephir',
                    value: modidzephir,
                    allowBlank:true
                },{
                    xtype: "arvcombo",
                    id: 'tmplnode',
                    fieldLabel: Ext.i18n.addnode1_tmplnode,
                    record: [
                        {name : 'tmplnode'},
                        {name : 'id'},
                        {name : 'mimetype'},
                    ],
                    url: 'arv/get_tmpl_nodes',
                    displayField:'tmplnode',
                    listen: {
                        'load': function(store, records, option){
                            if (records.length != 0) {
                                if (modmimetype == null) {
                                    Ext.getCmp('tmplnode').setValue(records[0].get('id'));
                                }
                                else{
                                    var arrayLength = records.length;
                                    for (var i = 0; i < arrayLength; i++) {
                                        if (modmimetype == records[i].data.mimetype){
                                            Ext.getCmp('tmplnode').setValue(records[i].get('id'));
                                        }
                                    }
                                    Ext.getCmp('tmplnode').disable();
                                }

                            }
                        }
                    }
                }],
            },{
                //Si on est en mode Zéphir
                id: 'card-2',
                xtype: 'grid',
                border: false,
                layout: 'fit',
                store: zephir_store,
                colModel: new Ext.grid.ColumnModel({
                    columns: [
                        {id: 'uai', header: Ext.i18n.zephir_etab_uai, dataIndex: 'uai'},
                        {id: 'libelle', header: Ext.i18n.zephir_etab_libelle, dataIndex: 'libelle', width: 150},
                        {id: 'id_zephir', header: Ext.i18n.id_zephir, dataIndex: 'id_zephir'},
                        {id: 'eole_version', header: Ext.i18n.eole_version, dataIndex: 'eole_version'},
                        {id: 'mimetype', header: Ext.i18n.tmpl_node_mimetype, dataIndex: 'mimetype'},
                    ],
                    defaults: {
                        sortable: true,
                        resizable: true,
                    },
                }),
                //singleSelect
                sm: new Ext.grid.RowSelectionModel({
                    singleSelect:true,
                }),
                enableColumnHide: false,
            },{
                id: 'card-3',
                xtype: 'editorgrid',
                border: false,
                layout: 'fit',
                clicksToEdit: 1,
                store: property_store,
                bbar: [{
                    id: 'reload_tmplvertex',
                    text: Ext.i18n.reload_tmplvertex,
                    handler: function() {
                            property_store.baseParams={
                                nodeid: modid,
                                uai: moduai,
                                id_zephir: modidzephir,
                                name: modname,
                                force_zephir: 'true'
                            };
                            property_store.load();
                    },
                    disabled: true
                }],
                colModel: new Ext.grid.ColumnModel({
                    columns: [
                        {id: 'tmplvertex', header: Ext.i18n.tmplvertex_name, sortable: true, dataIndex: 'tmplvertex'},
                        {id: 'mimetype', header: Ext.i18n.tmplvertex_mimetype, sortable: true, dataIndex: 'mimetype'},
                        {
                            id: 'ip1',
                            header: Ext.i18n.tmplvertex_ip1,
                            sortable: true,
                            dataIndex: 'ip1',
                            editor: new Ext.form.TextField({
                                vtype: 'IPAddress',
                                allowBlank: true
                            })
                        },
                        {
                            id: 'ip2',
                            header: Ext.i18n.tmplvertex_ip2,
                            sortable: true,
                            dataIndex: 'ip2',
                            editor: new Ext.form.TextField({
                                vtype: 'IPAddress',
                                allowBlank: true
                            })
                        }
                    ],
                    defaults: {
                        sortable: true,
                    },
                }),
                //singleSelect
                sm: new Ext.grid.RowSelectionModel({
                    singleSelect:true,
                }),
                enableColumnHide: false,
            }];

            zephir_store.removeAll();
            zephir_store.load();

            var navHandler = function(incr){
                var l = Ext.getCmp('addnode1-wizard-panel').getLayout();
                var i = parseInt(l.activeItem.id.split('card-')[1]);
                var node_method = Ext.getCmp('card-0').getForm().getValues()['node_method'];
                if ((node_method == 'node_zephir') && modid == undefined) {
                    switch (i) {
                        case 0: if (incr == 1) {next = 2};
                        break;
                        case 2: if (incr == 1) {
                                    next = 3
                                } else {
                                    next = 0
                                };
                        break;
                        case 3: if (incr == -1) {next = 2}
                    };
                } else {
                    switch (i) {
                        case 0: if (incr == 1) {next = 1};
                        break;
                        case 1:if (incr == 1) {
                                   next = 3
                               } else {
                                   next = 0
                               };
                        break;
                        case 3: if (incr == -1) {next = 1}
                    };
                };
                
                //var next = i + incr;
                //console.log('next: '+next);
                switch (next) {
                    case 0:
                            //choice between zephir/manuel
                            Ext.getCmp('save-button').disable();
                    break;
                    case 1:
                            //manuel
                            tmplnode_store = Ext.getCmp('tmplnode').store;
                            tmplnode_store.baseParams={};
                            tmplnode_store.load();
                    break;
                    case 2:
                            //zephir
                            tmplnode_store = Ext.getCmp('tmplnode').store;
                            tmplnode_store.baseParams={};
                            tmplnode_store.load();
                            /*if ((Ext.getCmp('nodename').getValue() == '') ||
                                (Ext.getCmp('tmplnode').getValue() == '')) {
                                error_msg(Ext.i18n.field_empty)
                                return;
                            };*/
                    break;
                    case 3:
                        //zephir + manuel
                        property_store.removeAll();


                        if ((node_method == 'node_zephir') && modid == undefined) {
                            grid_model = Ext.getCmp('card-2').getSelectionModel();
                            if (! grid_model.hasSelection()) {
                                error_msg(Ext.i18n.error_zephir_id);
                                return
                            }
                            mimetype = grid_model.getSelected().get('mimetype');
                            //cherche dans tmplnode l'ID du tmplnode pour
                            //mimetype de la machine selectionnee
                            tmplnode_obj = Ext.getCmp('tmplnode').getStore();
                            index = tmplnode_obj.find('mimetype', mimetype);
                            rec = tmplnode_obj.getAt(index);
                            if (rec == null) {
                                error_msg(Ext.i18n.error_get_tmplnode);
                                return
                            };
                            tmplnode = rec.id;
                            uai = grid_model.getSelected().get('uai');
                            name = grid_model.getSelected().get('name');
                            id_zephir = grid_model.getSelected().get('id_zephir');
                            property_store.baseParams={
                                tmplnodeid: tmplnode, uai: uai, name: name, id_zephir: id_zephir
                            };
                        } else {
                            tmplnode = Ext.getCmp('tmplnode').getValue()
                            if (modid == undefined){
                                idzephir = Ext.getCmp('card-1').getForm().getValues()['id_zephir'];
                                if(idzephir != ''){
                                    uai = Ext.getCmp('card-1').getForm().getValues()['uai'];
                                    name = Ext.getCmp('card-1').getForm().getValues()['name'];
                                    property_store.baseParams={
                                        tmplnodeid: tmplnode, uai: uai, name: name, id_zephir: idzephir
                                    };
                                }else{
                                    property_store.baseParams={
                                        tmplnodeid: tmplnode
                                    };
                                }
                            }else{
                                if (modid != null){
                                    property_store.baseParams={
                                        nodeid: modid
                                    };
                                }else{
                                    property_store.baseParams={
                                        tmplnodeid: tmplnode
                                    };
                                }
                            }
                        }
                        
                        property_store.load();
                        Ext.getCmp('save-button').enable();
                    break;
                };
                l.setActiveItem(next);
                nbcard = next;
                
                Ext.getCmp('card-prev').setDisabled(next==1);
                Ext.getCmp('card-next').setDisabled(next==3);

            };

            if (modid == null) {
                var nbcard = 0;
            } else {
                var nbcard = 1;
            };

            var wizard = {
                id:'addnode1-wizard-panel',
                xtype: 'panel',
                layout:'card',
                border: false,
                activeItem: nbcard,
                bbar: ['->', {
                    id: 'card-prev',
                    text: '&laquo; '+ Ext.i18n.previous,
                    handler: navHandler.createDelegate(this, [-1]),
                    disabled: true,

                },{
                    id: 'card-next',
                    text: Ext.i18n.next+' &raquo;',
                    handler: navHandler.createDelegate(this, [1]),

                }],
                items: cardcontent,
                buttons: [{
                    text: Ext.i18n.cancel,
                    handler: function(){
                        winaddnode1.destroy();
                    }
                },{
                    id: 'save-button',
                    text: Ext.i18n.ok,
                    disabled: true,
                    handler: function() {
                        var node_method = Ext.getCmp('card-0').getForm().getValues()['node_method'];
                        var records = {};
                        Ext.getCmp('card-3').getStore().each(
                            function (record){
                                records[record.get('id')] = Array(record.get('ip1'), record.get('ip2'));
                            }
                        );
                        retjson = Ext.util.JSON.encode(records);
                        
                        id_zephir = Ext.getCmp('id_zephir').getValue();
                        if (modid != null) {
                                //si modifie
                                if (id_zephir != ''){
                                    is_available = false;
                                    if (id_zephir == modidzephir){
                                        is_available = true;
                                    }else{
                                        zephir_store.each(
                                            function (record){
                                                if (record.data.id_zephir == parseInt(id_zephir)){
                                                    is_available = true
                                                }
                                            }
                                        );
                                    }
                                    if (!is_available) {
                                        
                                        error_msg(Ext.i18n.error_get_tmplnode);
                                        return
                                    }
                                }
                                uai = Ext.getCmp('card-1').getForm().getValues()['uai'];
                                name = Ext.getCmp('card-1').getForm().getValues()['name'];
                                mimetype = Ext.getCmp('card-1').getForm().getValues()['mimetype'];
                                
                                Ext.Ajax.request({
                                    url: 'arv/mod_node',
                                    params: {
                                        vertices: retjson,
                                        name: name,
                                        uai: uai,
                                        id_zephir: id_zephir,
                                        mimetype: mimetype,
                                        node: modid},
                                    success: response_success,
                                })
                        } else {
                            if (node_method == 'node_zephir') {
                                 //if with zephir, name of node is UAI
                                selected = Ext.getCmp('card-2').getSelectionModel().getSelected();
                                name = selected.get('libelle');
                                uai = selected.get('uai');
                                id_zephir = selected.get('id_zephir');
                                eole_version = selected.get('eole_version');
                                mimetype = selected.get('mimetype');
                                Ext.Ajax.request({
                                    url: 'arv/add_node',
                                    params: {
                                        vertices: retjson,
                                        name: name,
                                        mimetype: mimetype,
                                        uai: uai,
                                        id_zephir: id_zephir,
                                        eole_version: eole_version,
                                    },
                                    success: response_success,
                                })
                            } else {
                                id_zephir = Ext.getCmp('card-1').getForm().getValues()['id_zephir'];
                                Ext.getCmp('card-1').getForm().submit({
                                    url: 'arv/add_node',
                                    params: {
                                        vertices: retjson,
                                        id_zephir: id_zephir},
                                    success: response_success,
                                })
                            }
                        }
                    }
                }]
            };
            var response_success = function(response, options){
                ARV.observable.fireEvent("treenode1changed");
                winaddnode1.destroy();
            };
            if (modid != null) {
                var winaddnode1 = new ARV.PopupWindow({
            		width: 450,
                    title: Ext.i18n.modify_node1_title,
                    items: [wizard]
                }).show();
            } else {
                var winaddnode1 = new ARV.PopupWindow({
            		width: 570,
                    title: Ext.i18n.addnode1_title,
                    items: [wizard]
                }).show();
            };
            if (modid != null) {
                property_store.baseParams={nodeid: modid};
                property_store.load();
                Ext.getCmp('save-button').enable();

                Ext.getCmp('card-next').enable();

                Ext.getCmp('reload_tmplvertex').enable();
            };

            if (Ext.util.Cookies.get('usezephir') == 'false') {
                Ext.getCmp('node_zephir').disable();
                Ext.getCmp('node_manually').setValue(true);
                Ext.getCmp('id_zephir').disable();
            };
        }
    };
})();

// vim: ts=4 sw=4 expandtab
