# -*- coding: UTF-8 -*-
"""website generic pages
"""
from subprocess import getstatusoutput
from twisted.web import resource, server
from zope.interface import Interface
from twisted.python import components
from arv.config import sw_database_mode
from arv.db.initialize import commit_database, rollback_database
from arv.lib.sw_config_apply import db_apply, ipsec_conf_apply
from arv.lib.factory import get_object_by_id
from arv.lib.logger import logger
import logging
try:
    from creole.client import CreoleClient
    conf_eole = CreoleClient().get_creole()
    activer_haute_dispo = conf_eole['activer_haute_dispo']
except:
    activer_haute_dispo = 'non'
    pass

# ____________________________________________________________
#
from arv.config import (arv_port, arv_ssl, arv_crt, arv_key, arv_static_path,
        allow_user)
try:
    import json
except:

    import simplejson as json

import PAM

try:
    from arv.lib.usezephir import Zephir
    usezephir = True
    logger.debug('usezephir: True')
except:
    usezephir = False
    logger.debug('usezephir: False : %s' % logger.debug(traceback.format_exc()))


# ____________________________________________________________
# authentification session
class IPreferences(Interface):
    pass

class Preferences(components.Adapter):
    __implements__ = IPreferences

    def __init__(self,original):
        self.authentified = 'no'
        components.Adapter.__init__(self,original)

components.registerAdapter(Preferences, server.Session, IPreferences)

# ____________________________________________________________
# Page abstract class
class Page(resource.Resource):
    """
        abstract page
    """
    isLeaf = True
    save_database = False

    ## authentification
    def close_session(self, request):
        prefs = request.getSession(IPreferences)
        prefs.authentified = 'no'
        # FIXME hook authenticate
        prefs.zephir = None

    def require_auth(self, request):
        prefs = request.getSession(IPreferences)
        return self.send_json(auth=False) # errpage.render(request)

    def render(self, request):
        logger.debug('-> entering Page.render()')
        # is the session authentified ? authentified = yes or no
        prefs = request.getSession(IPreferences)
        if hasattr(prefs, 'authentified'):
            if prefs.authentified != 'yes':
                return self.require_auth(request)
            else:
                try:
                    ret = self.render_page(request)
                    #@gwen
                    if type(ret) == tuple:
                        if ret[0] == 'download_name':
                            return self.send_json(download=ret[1], message=ret[2])
                        elif ret[0] == 'download_file':
                            message=ret[2]
                            logger.debug('return is a download file')
                            #logger.debug('download file content: ' + message)
                            request.setHeader('Content-disposition', 'attachment; filename=%s'%ret[1])
                            request.setHeader('Content-Length', str(len(message)))
                            request.setHeader('Content-Type', 'application/force-download')
                            return message
                        else:
                            raise Exception('unkown argument for %s', str(ret))
                    elif type(ret) == str:
                        return self.send_json(message=ret)
                    else:
                        return self.send_json(ret=ret)
                except Exception as e:
                    import traceback
                    logger.critical('Error in %s with args %s'%(self.__class__.__name__, str(request.args)))
                    logger.critical(traceback.format_exc())
                    return self.send_json(error=str(e))

    ## getters
    def get_data_from_request(self, request, arg, load_json=False, object_type=None, required=True):
        """
        Return arg from request. If object_type specified, return object
        request is return by twister
        arg: name of argument return by user
        load_json: if value is a json type
        object_type: if value is an id of an object, specify the object type
                     to return directly the object
        required: if True, return a ValueError if argument is not specify by
                  user or is no object has this id
        """
        #if arg is in the request
        if not isinstance(arg, bytes):
            arg = arg.encode()
        if arg in request.args:
            try:
                #return value
                if object_type == None:
                    ret = request.args[arg][0]
                    if load_json == True:
                        #load json value
                        return json.loads(ret)
                    else:
                        return ret
                #return object
                else:
                    obj = get_object_by_id(request.args[arg][0], object_type)
                    if required and obj == None:
                        raise ValueError("value %s required"% str(arg))
                    return obj
            except Exception as e:
                raise ValueError(str(e))
        else:
            if required:
                raise ValueError("value %s required"% str(arg))
            else:
                return None

    def send_json(self, ret=None, error=None, message=None, auth=True, treenode=False, download=None):
        """
        Convert answer to json for extjs
        error: if return an error, error must be the error message
        message: if a message must be displayed (not an error message)
        """
        #if authentified session
        if auth == True:
            buf = {'success': True, 'data': '', 'authentification': True}
            if error == None:
                if self.save_database:
                    try:
                        commit_database()
                    except:
                        import traceback
                        logger.critical(traceback.format_exc())
                        error = "error while saving database"
                if ret != None:
                    if treenode == True:
                        #if treenode
                        buf = ret
                    if isinstance(ret, list):
                        buf['data'] = []
                        for item in ret:
                            dico = {}
                            for key, value in item.items():
                                if isinstance(value, bytes):
                                    value = value.decode()
                                dico[key] = value
                            buf['data'].append(dico)
                    else:
                        buf['data'] = ret
                if message != None:
                    buf['message'] = message
            if error != None:
                if self.save_database:
                    rollback_database()
                buf = {'success': False, 'data': '', 'message': error}
            if download != None:
                buf['download'] = download
        #if session is not authentified
        else:
            buf = {'success': True, 'data': '', 'authentification': False}
            if error != None:
                buf['success'] = False
                buf['message'] = error

        return json.dumps(buf).encode()

class Login(Page):
    isLeaf = True

    def render(self, request):
        try:
            user = self.get_data_from_request(request=request, arg=b'user').decode()
            password = self.get_data_from_request(request=request, arg=b'password').decode()
        except Exception as e:
            return self.send_json(error=str(e))
        if allow_user != None and user not in allow_user:
            return self.send_json(error='User not allowed', auth=False)
        prefs = request.getSession(IPreferences)
        # PAM stuff
        def pam_conv(auth, query_list, userData):
            """pam password authentification utility
            """
            resp = []
            for i in range(len(query_list)):
                query, type = query_list[i]
                if type == PAM.PAM_PROMPT_ECHO_ON or type == PAM.PAM_PROMPT_ECHO_OFF:
                    resp.append((password, 0))
                elif type == PAM.PAM_PROMPT_ERROR_MSG or type == PAM.PAM_PROMPT_TEXT_INFO:
                    resp.append(('', 0))
                else:
                    return None

            return resp

        if usezephir == True:
            try:
                prefs.zephir = Zephir(user=user, password=password)
                prefs.user = user
                prefs.authentified = 'yes'
                return self.send_json(ret={'zephir': True}, message='Successful login', auth=True)
            except Exception as err:
                if logger.isEnabledFor(logging.DEBUG):
                    logger.debug(err, exc_info=True)
                else:
                    logger.info(err)

        prefs.zephir = None
        auth = PAM.pam()
        auth.start('arv')
        auth.set_item(PAM.PAM_USER, user)
        auth.set_item(PAM.PAM_CONV, pam_conv)
        try:
            auth.authenticate()
            auth.acct_mgmt()
            prefs.user = user
            prefs.authentified = 'yes'
            return self.send_json(ret={'zephir': False}, message='Successful login', auth=True)
        except PAM.error as resp:
            print('Go away! (%s)' % resp)
            prefs.authentified = 'no'
            return self.send_json(error='Login failed', auth=False)
        except:
            prefs.authentified = 'no'
            return self.send_json(error='Login failed, internal error', auth=False)
            print('Internal error')

class Apply(Page):
    def render_page(self, request):
        zephir = None
        prefs = request.getSession(IPreferences)
        if prefs.zephir != None:
            zephir = prefs.zephir
        if sw_database_mode == 'oui':
            db_apply(zephir=zephir)
            msg = "Database created"
        else:
            ipsec_conf_apply(zephir=zephir)
            msg = "Configuration created"
        if activer_haute_dispo != 'non':
            cmd = '/usr/share/eole/sbin/synchro-nodes.sh'
            errcode, output = getstatusoutput(cmd)
            if errcode:
                msg += " - !!! HighAvail synchro : remote node unreachable !!!"
        return msg

# ____________________________________________________________

class Close(Page):
    def render_page(self, request):
        self.close_session(request)
        return ''

