# -*- coding:utf-8 -*-
from .elixir import Entity
from sqlalchemy import Column
from sqlalchemy.types import UnicodeText, Integer
from arv.lib.util import trace

class DbVersion(Entity):
    __tablename__ = 'arv_db_version_dbversion'
    id = Column(Integer, primary_key=True)
    # Database version
    version = Column(UnicodeText)

@trace()
def add_mod_DbVersion(version):
    try:
        Actual_version = DbVersion.query.first()
        if Actual_version:
            if Actual_version.version != version:
                Actual_version.version = version
            return Actual_version
        else:
            return DbVersion(version=version)
    except:
        # No version table
        return None

@trace()
def get_DbVersion():
    try:
        return DbVersion.query.first().version
    except:
        # No version table or no record
        return None

