import sys
from os.path import isfile
from arv.db.elixir import setup_all, session, Entity, create_all
from arv.config import sqlite_database

def initialize_database(create=False):
    #metadata.bind.echo = True
    setup_all()
    if create:
        create_all()
    else:
        if not isfile(sqlite_database):
            print("ERROR: --- unable to find ARV database, please create it first ---")
            sys.exit(1)

def commit_database():
    session.commit()
    session.flush()

def rollback_database():
    session.rollback()
#    session.clear()
