# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# Outil de parsing pour les sets ipset
#
###########################################################################
""" Outil de parsing pour les sets ipset """
from twisted.python import log
#from optparse import OptionParser, make_option

class Parser:
    """ parse le résultat de ipset --save """

    #def parse_command_line(self, line):
    #    """Construit le parser d'options de la ligne de commande,
    #    parse la ligne de commande, et retourne
    #    les options
    #    """
    #    option_list = [
    #                make_option('-N', action="store", type="string", dest="setname"),
    #                make_option('-A', action="store", type="string", dest="setitem"),
    #                make_option('-B', action="store", type="string", dest="binded"),
    #                ]
    #    parser = OptionParser(option_list=option_list)
    #    options = parser.parse_args(args=line)[0]
    #    return options

    def parse_ipset_line(self, line):
        """ parse une ligne de conf ipset """
        line = line.split()
        if line[0] == 'create':
            return self.parse_new_ipset_line(line)
        if line[0] == 'add' != None:
            return self.parse_add_item_ipset_line(line)

    def parse_new_ipset_line(self, line):
        """ reçoit une ligne de creation de set la forme:
            "create web_services bitmap:port range 0-65000"
            et la tranfsorme en dico
        """
        if not line[1].startswith('group-'):
            return
        name = line[1]
        try:
            # on a un port map ou un ipmap set
            assert line[2] == 'bitmap:port'
            settype = 'portmap'
            assert line[3] == 'range'
            start, end = line[4].split('-')
            return dict(instruction='create', name=name, settype=settype, start=start, end=end)
        except (IndexError, AssertionError):
            settype = 'unknown'
            return dict(instruction='create', name=name, settype=settype)

    def parse_add_item_ipset_line(self, line):
        """ reçoit une ligne d'ajout d'item à un set de la forme:
            nomduset item
            et la transforme en dico
        """
        if not line[1].startswith('group-'):
            return
        name = line[1]
        item = line[2]
        return dict(instruction='add', name=name, item=item)

    def parse_bind_ipset_line(self, line):
        """ reçoit une ligne de binding de set de la forme:
            nomduset itemabinder -b nomdusetabinder
            et le transforme en dico
        """
        line = line.split('-b')
        name, item = line[0].split()
        binded = line[1].strip()
        return dict(instruction='bind', name=name, item=item, binded=binded)
