# -*- coding: utf-8 -*-
from os.path import join
from os import listdir
from amon.config import DANS_NUM_OPT_FILTERS, CONTAINER_PATH_PROXY

# lien entre les nom d'actions de l'ead2 et les numeros d'instance
NAME_DICT = {1:'pedago', 0:'admin'}
num_policies = DANS_NUM_OPT_FILTERS + 4
whitelist_policy = [4]
other_spec_policies = [2, 3]
spec_policies = whitelist_policy + other_spec_policies
policies = list(range(1, num_policies+1))
optional_policies = list(set(policies).difference(set(spec_policies)))
optional_policies.sort()

PRXOY_PATH = CONTAINER_PATH_PROXY

# edition de /etc/dansguardian.../
EOLE_DIR = '/usr/share/eole/dansguardian/'
TEMPLATE_DIR = join(EOLE_DIR, 'templates')
COMMON_TEMPLATE_DIR = join(EOLE_DIR, 'common')
WHITELIST_TEMPLATE_DIR = join(EOLE_DIR, 'whitelist_templates')
CLAMD_TEMPLATE_DIR = join(EOLE_DIR, 'contentscanners')
# -> conteneur
DANS_DIR = '/etc/guardian/guardian%d/'
DANS_FULL_DIR = PRXOY_PATH+DANS_DIR

# sous-répertoire de /etc/dansguardian/ communs copiés tel quel
instance_fix_subdirs = ['downloadmanagers', 'authplugins', 'lists']
# sous-répertoire de /etc/dansguardian/ spécifiques pour chaque polititque
# (crée des répertoires listsf<indice>)
instance_spec_subdirs = ['lists']
# templates communs à l'instance (importation depuis dansguardian.conf)
#instance_common_templates = listdir(COMMON_TEMPLATE_DIR)
# templates spécifiques à chaque politique de filtrage
instance_subdirs_templates = listdir(TEMPLATE_DIR)
# templates spécifiques à la liste blanche utilisateur
instance_whitelist_templates = listdir(WHITELIST_TEMPLATE_DIR)
# templates spécifiques à clamd (templatisé et copié dans contentscanners)
instance_clamd_templates = listdir(CLAMD_TEMPLATE_DIR)

# edition de /var/lib/blacklists
LOCAL_TEMPLATE_DIR = join(EOLE_DIR, 'local_templates')
# -> conteneur
LOCAL_DIR = join('/', PRXOY_PATH, 'var/lib/blacklists/')
DANS_LOCAL_DIR = join(LOCAL_DIR, 'dansguardian%d/')
DANS_LOCAL_SUBDIR = join(DANS_LOCAL_DIR, "f%d")

local_common_conf_files = ['spusers', 'users', 'hosts', 'filtergroupslist',
    'urls', 'ipgroupslist', 'domains_acad', 'urls_acad']
local_spec_conf_files = ['whites', 'domains', 'types_mime', 'extensions']
local_whitelist_conf_files = ['site_liste_blanche', 'url_liste_blanche',
    'exceptionsitelist', 'exceptionurllist'] + local_spec_conf_files
#FIXME : fichiers déportés de /etc vers /var/lib/ afin d'éditer les # au lieu
#        de jouer avec des liens (ajout_filtres.sh)
local_deported_files = ['bannedsitelist', 'bannedurllist']

# fichier d'association item-politique (où item est un user ou une ip
filtergroupslist = join(DANS_LOCAL_DIR, 'common', 'filtergroupslist')
ipgroupslist = join(DANS_LOCAL_DIR, 'common', 'ipgroupslist')
amon_perms = '/usr/share/ead2/backend/config/perms/perm_amon.ini'
proxy_perms = '/usr/share/ead2/backend/config/perms/perm_proxy.ini'
dans_status = "/var/lib/eole/config/filtrage-contenu%d"
