# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# Test du module de gestion des règles iptables pour les postes
# (destinations et postes interdits)
#
###########################################################################
""" teste postes.py
    nécessite un amon configuré avec eth0 en gateway et eth1 avec la configuration 0
    erreur py.test observé: remplacement d'une partie de chaine par '...'

"""

from . import autopath
from amon.era import postes

def setup_module(module):
    """ initialisation """
    postes.f_poste_name = {'all':'/tmp/test_all%d.txt',
                           'web':'/tmp/test_web%d.txt',
                           'destination':'/tmp/test_dest%d.txt'}

def test_get_interface():
    """ teste la détection d'interface """
    assert ['eth1'] == postes.get_interface(0)

def test_web_interdiction():
    """ teste les interdictions de web pour des postes (inclue les horaires) """
    poste1 = {'poste':'1.1.1.1', 'hdeb':'10:00', 'hfin':'15:00', 'jdeb':'lundi', 'jfin':'jeudi', 'interface':'eth1'}
    poste2 = {'poste':'1.1.1.2', 'hdeb':'15:00', 'hfin':'19:00', 'jdeb':'Thu', 'jfin':'Mon'}

    postes.save_forbidden_poste(0, 'web', [poste1, poste2])
    assert postes.load_forbidden_poste(0, 'web') == [poste1, poste2]
    postes.save_forbidden_poste(0, 'web', [poste1])
    assert postes.generate_postes_rules() == """/sbin/iptables -I INPUT -p tcp --dport 3128 -i eth1 -s 1.1.1.1 -m time --timestart 10:00 --timestop 15:00 --weekdays Mon,Thu,Wed,Tue\n/sbin/iptables -I FORWARD -i eth1 -o eth0 -s 1.1.1.1 -m time --timestart 10:00 --timestop 15:00 --weekdays Mon,Thu,Wed,Tue\n"""
    postes.save_forbidden_poste(0, 'web', [])
    assert postes.load_forbidden_poste(0, 'web') == []

def test_all_interdiction():
    """ teste les interdictions de poste pour l'ensemble du réseau """
    poste1 = {'poste':'1.1.1.1', 'interface':'eth1'}
    poste2 = {'poste':'1.2.1.2'}

    postes.save_forbidden_poste(0, 'all', [poste1, poste2])
    assert postes.load_forbidden_poste(0, 'all') == [poste1, poste2]
    postes.save_forbidden_poste(0, 'all', [])
    assert postes.load_forbidden_poste(0, 'all') == []

def test_destination():
    """ teste l'interdiction de destinations """
    dest1 = {'poste':'1.1.1.1', 'interface':'eth1'}
    dest2 = {'poste':'1.1.1.2'}

    postes.save_forbidden_poste(0, 'destination', [dest1, dest2])
    assert postes.load_forbidden_poste(0, 'destination') == [dest1, dest2]
    assert postes.generate_destinations_rules() == """/sbin/iptables  -I FORWARD -i eth1 -d 1.1.1.1 -j DROP\n/sbin/iptables -I INPUT -i eth1 -s 1.1.1.1 -j DROP\n/sbin/iptables  -I FORWARD -i eth1 -d 1.1.1.2 -j DROP\n/sbin/iptables -I INPUT -i eth1 -s 1.1.1.2 -j DROP\n"""
    postes.save_forbidden_poste(0, 'destination', [])
    assert postes.load_forbidden_poste(0, 'destination') == []

