# -*- coding: UTF-8 -*-
"""
    backend de gestion de Amon
"""
import time
from os import environ
from subprocess import PIPE, Popen, STDOUT
from contextlib import contextmanager
from amon.config import NOMBRE_INTERFACES, NUM_DANSGUARDIAN_INSTANCE, ACTIVER_SQUID_AUTH, \
        ACTIVER_SQUID2, DANSGUARDIAN_ETH, IP_ETH, NETWORK_ETH, NETMASK_ETH, NOM_MACHINE_ETH, \
        ACTIVER_PROXY_ETH, SQUID_AUTH_ETH, VLAN_ETH, ALIAS_ETH, TIMEZONE, NOM_CARTE_ETH

### Collecte des interfaces par politique de filtrage
def get_zones():
    """
        recupere les zones de configuration dans le dico creole
        en associant: {num de zone: [liste des interfaces]}
        authentification : si l'authentification est activée,
                           elle l'est sur toutes les interfaces
    """
    nb_ifaces = NOMBRE_INTERFACES

    NUM_INSTANCE = NUM_DANSGUARDIAN_INSTANCE

    ifaces = dict([(indice, [])for indice in range(0, NUM_INSTANCE)])

    def get_iface_ip(num_iface):
        """ récupère l'ip de m'interface ethnum_iface"""
        return IP_ETH[num_iface]

    def get_iface_vlan_ips(num_iface):
        """ récupère les ips associées à l'interface vlans compris
        """
        return VLAN_ETH[num_iface]

    def get_iface_alias_ips(num_iface):
        """ récupère les ips associées à l'interface alias compris
        """
        return ALIAS_ETH[num_iface]

    def auth_eth(eth_auth, global_auth):
        """ renvoie True si l'eth est authentifiée
        """
        if global_auth == 'oui':
            return eth_auth
        else:
            return 'non'

    # param d'auth globale
    activer_squid_auth = ACTIVER_SQUID_AUTH

    # petite astuce suite à la suppression des variables :
    # activer_proxy_eth0 & squid_auth_eth0 #3413
    if nb_ifaces == 1:
        proxy_ifaces = [0]
    else:
        proxy_ifaces = range(1, nb_ifaces)

    squid2 = ACTIVER_SQUID2
    for n in proxy_ifaces:
        #verifier si le proxy est activé sur cette interface
        eth_activer_proxy = ACTIVER_PROXY_ETH[n]
        if eth_activer_proxy == "oui":
            # param d'auth de l'interface
            eth_squid_auth = SQUID_AUTH_ETH[n]
            # eth authentifiée ?
            eth_is_auth = auth_eth(eth_squid_auth, activer_squid_auth)
            nom_machine = NOM_MACHINE_ETH[n]
            interface = {"adresse_network" : NETWORK_ETH[n],
                         "adresse_netmask" : NETMASK_ETH[n],
                         "adresse_ip" : get_iface_ip(n),
                         "nom_machine" : nom_machine,
                         "activer_squid_auth": eth_is_auth,
                         "nom": NOM_CARTE_ETH['eth{}'.format(n)],
                         "adresse_ip_vlans" : get_iface_vlan_ips(n),
                         "adresse_ip_alias" : get_iface_alias_ips(n),
                         }
            instance = DANSGUARDIAN_ETH[n]
            ifaces[int(instance)-1].append(interface)
            # Deuxieme instance de squid ?
            if  squid2 == "oui":
                ifaces[NUM_INSTANCE-1].append(interface)

    return ifaces, NUM_INSTANCE

def get_filter_zones():
    """
        recupere les zones depuis creole
    """
    ifaces, num_instance = get_zones()
    return ifaces

def get_interfaces(zone):
    """ renvoie un dico {eth*:libellé de l'interface}
        pour les interfaces de zone de configuration zone
    """
    ifaces = get_filter_zones()[zone]
    return dict([(iface['nom'],iface['nom_machine'])for iface in ifaces])

def get_other_interfaces(zone):
    """
        renvoie le dico {eth*:libellé de l'interface}
        pour les interfaces des autres zones
    """
    zones_dict = get_filter_zones()
    zones = list(zones_dict.keys())
    if zone != None:
        zones.remove(zone)
    ifaces = []
    for z in zones:
        ifaces.extend(zones_dict[z])
    return dict([(iface['nom'],iface['nom_machine'])for iface in ifaces])

#######################################
# UTILITAIRES DE DETECTION D'INTERFACE
#######################################

def detect_interface(iface_ip, ip):
    """
        détecte si une adresse ip fait partie de la plage d'ip
        du sous réseau défini par iface
    """
    if len(ip.split('.')) == 4:
        if ip.split('.')[:3] == iface_ip.split('.')[:3]:
            return True
    return False

def get_interface(zone, ip=None):
    """
        renvoie l'interface à laquelle une ip est associée
        (comparaison d'adresse)
        et renvoie la première adresse si on trouve rien
    """
    zone_eths = get_filter_zones()[zone]

    if ip is None: return [iface['nom'] for iface in zone_eths]

    for iface in zone_eths:
        if detect_interface(iface['adresse_ip'], ip):
            return  iface['nom']
        else:
            # par défaut on prend la première interface associée à la configuration
            if len(zone_eths) > 0:
                return zone_eths[0]['nom']
            else:
                raise Exception("Cette zone de filtrage n'a pas d'interface associée.")
    return None

def is_auth(zone):
    """
        True si l'auth squid est activée sur toutes les interfaces de la zone
        False sinon
    """
    for iface in get_filter_zones()[zone]:
        if iface['activer_squid_auth'] == 'non':
            return False
    return True

def is_there_auth(zone):
    """
        y-a-t-il une interface authentifiée dans la zone
    """
    for iface in get_filter_zones()[zone]:
        if iface['activer_squid_auth'] == 'oui':
            return True
    return False

## fonction d'éxécution de commande avec subprocess (à la place de commands)
def cmdtolist(str):
    """ cree une liste de commande depuis une string """
    cmdlist=[]
    current=[]
    gc=''
    last=''
    for c in str:
        if (c == '\\'):
            pass
        elif (last == '\\'):
            current.append(c)
        elif (gc != ''):
            if (c != gc):
                current.append(c)
            else:
                gc=''
        else:
            if (c.isspace()):
                cmdlist.append(''.join(current))
                current = []
            elif (c == '"'):
                gc = c
            elif (c == "'"):
                gc = c
            else:
                current.append(c)
        last = c
    if (len(current) != 0):
        cmdlist.append(''.join(current))
    cmdlist.insert(0, 'sudo')
    return cmdlist

class Fpipe:
    def __init__(self, fn, stdin=None):
        self.fn = fn
        self.stdin = stdin
        self.stdout = StringIO.StringIO()
    def call(self):
        self.fn(self.stdin, self.stdout)

def command_statusoutput(*cmds):
    """ equivalent à commands.getstatusoutput mais avec subprocess,
        accepte plusieurs commande liées, (équivalent à 'cmd1 | cmd2')
        renvoie un code retour et le resultat de  la commande
    """
    def func():
        pass
    def norm(cmd):
        if (isinstance(cmd, str)):
            return cmdtolist(cmd)
        return cmd
    def pipeobj(cmd, stdin=None):
        if (callable(cmd)):
            fp = Fpipe(cmd, stdin)
            fp.call()
            fp.stdout.seek(0)
            return fp
        if (stdin is None):
            return Popen(norm(cmd), stdout=PIPE, stderr=STDOUT)
        else:
            return Popen(norm(cmd), stdin=stdin, stdout=PIPE, stderr=STDOUT)
    if (len(cmds) == 0):
        return
    prev = None
    for cmd in cmds:
        if (prev is None):
            prev = pipeobj(cmd)
        else:
            prev = pipeobj(cmd, stdin=prev.stdout)
    return_str = prev.communicate()[0].strip()
    return_code = prev.wait()
    return return_code, return_str

def command_output(cmd):
    """ renvoie le résultat d'une commande """
    cmd = cmd.split()
    cmd.insert(0, 'sudo')
    return Popen(cmd, stdout=PIPE, stderr=PIPE, stdin=PIPE).communicate()[0]

#
@contextmanager
def local_timezone(zonename):
    #NOTE: it manipulates global state
    oldname = environ.get('TZ')
    try:
        environ['TZ'] = zonename
        time.tzset()
        yield
    finally:
        if oldname is None:
            del environ['TZ']
        else:
            environ['TZ'] = oldname
        time.tzset()

def get_dst_offset():
    with local_timezone(TIMEZONE):
        if time.localtime().tm_isdst > 0:
            return time.altzone
        else:
            return time.timezone


