#-*-coding:utf-8-*-
""" script de migration pour les groupes de machine """
from amon import backend
from amon.ipset import group_manager
from amon.ipset import time_manager
from amon.ipset.schedule_inverter import invert_schedules, load_pickle
from os.path import join, isfile

# pour logger la migration
debug = False

SAVED_FILES_PATH = "/usr/share/ead2/backend/tmp/sauvegarde_migrations/ipset"

old_group_filename = join(SAVED_FILES_PATH, 'ipset_group.txt')
old_schedule_filename = join(SAVED_FILES_PATH, 'ipset_schedules.pickle')


def get_old_group_lines():
    return [group for group in open(old_group_filename).read().splitlines() if group != '']

def get_old_groups():
    """ renvoie la liste des groupes, attr, renvoie la liste des valeur de l'attribut attr des groupes
        @attr: nom de l'attribut
    """
    if isfile(old_group_filename):
        return [{'name':group.split('#')[0],
                 'ip_from':group.split('#')[1],
                 'ip_to':group.split('#')[2],
                 'active':group.split('#')[3],
                 'time':group.split('#')[4],
                 }for group in get_old_group_lines() if len(group.split('#'))>=5 ]
    return []

def add_interface_to_groups(groups, zones):
    """
        ajoute une interface à la configuration d'un groupe de machine
        et renvoie les groupes indéfinis dans une liste
    """
    # recuperation des zones
    all = backend.get_filter_zones()

    # initialisation du dico de retour
    zones_postes = {}
    for zone in zones:
        zones_postes[zone] = []
    undef = []

    for group in groups:
        ip = group['ip_from']
        for zone in zones:
            for iface in all[zone]:
                if backend.detect_interface(iface['adresse_ip'], ip):
                    interface = iface['nom']
                    group['interface'] = interface
                    zones_postes[zone].append(group)
                    if debug:
                        print("++++ Le groupe %s (de %s à %s) a été associée à l'interface %s sur la zone %s"%(group['name'],
                                                                                                group['ip_from'],
                                                                                                group['ip_to'],
                                                                                                interface,
                                                                                                zone))

        if 'interface' not in group:# groupe non placé, à renvoyer vers un fichier texte?
            #FIXME: sauvegarder
            undef.append(group)
    return zones_postes, undef

def migration_schedules(zone, groups, schedules):
    """
        migre les horaires pour la zone zone qui contient les groupes groups
    """
    tosave = {}
    for group in groups:
        sched = schedules.get(group['name'], None)
        if sched is not None:
            tosave[group['name']] = invert_schedules(sched)
    time_manager.save_schedules(zone, tosave)

def migration_ipset(auth='oui'):
    """ migre les groupes de machine """
    if auth == 'oui':
        zones = (0,1)
    else:
        zones = (0,)
    if debug:
        print("====> Migration des fichiers de configuration de groupe de machine")
    oldies = get_old_groups()
    zones_groups, undef_groups = add_interface_to_groups(oldies, zones)

    for zone, groups in zones_groups.items():
        for group in groups:
            try:
                group_manager.create_group(zone, group['name'], group['ip_from'], group['ip_to'], group['interface'])
            except:
                pass
            # activation du groupe si besoin
            if group['active'] =='1':
                if debug:
                    print("++++ Le groupe a été activé")
                group_manager.active(zone, group['name'])
            if group['time'] =='1':
                if debug:
                    print("++++ Les horaires du groupe ont été activé")
                group_manager.active_time(zone, group['name'])
        if isfile(old_schedule_filename):
            migration_schedules(zone, groups, load_pickle(old_schedule_filename))

    for group in undef_groups:
        if debug:
            print("++++ Le groupe %s n'a pas pu être associé à une interface."%group['name'])
        else:
            print("WARNING : des groupes de machine n'ont pas pu être associés à une interface.")
