# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# Test du module de chargement/modification de l'activation des règles
# optionnelles ERA
#
###########################################################################
""" teste regles.py
    nécessite un amon configuré avec eth0 en gateway et eth1 avec la configuration 0
"""

from amon.era import regles

era_tmp_fname = "/tmp/regles.csv"

def setup_module(module):
    """ initialisation """
    a = file(era_tmp_fname, 'w')
    regles.f_name_tmpl = era_tmp_fname
    a.write("test de regles internes,1,1,eth1\ntest de regles externes,1,1,eth0\n")
    a.close()


def test_load():
    """ test le chargement des règles optionnelles """
    regle_admin = regles.load(0)
    regle_ext = regles.load(None)
    assert regle_admin == [dict(desc="test de regles internes", val='1', occ="1", eth="eth1")]
    assert regle_ext == [dict(desc="test de regles externes", val='1', occ="1", eth="eth0")]

def test_save():
    """ test la sauvegarde des règles optionnelles """
    nouvelle_regle = dict(desc="test de regles internes", val='3', occ="1", eth="eth1")
    regles.save([nouvelle_regle])
    regle_admin = regles.load(0)
    regle_ext = regles.load(None)
    assert regle_admin == [dict(desc="test de regles internes", val='3', occ="1", eth="eth1")]
    assert regle_ext == [dict(desc="test de regles externes", val='1', occ="1", eth="eth0")]
    nouvelle_regle = dict(desc="test de regles externes", val='3', occ="1", eth="eth0")
    regles.save([nouvelle_regle])
    regle_admin = regles.load(0)
    regle_ext = regles.load(None)
    assert regle_admin == [dict(desc="test de regles internes", val='3', occ="1", eth="eth1")]
    assert regle_ext == [dict(desc="test de regles externes", val='3', occ="1", eth="eth0")]
