
-- On met à jour les adresses du bureau, de l'ead et du gestionnaire de profile
\r poshprofile
SET character_set_client = utf8;

DROP TABLE IF EXISTS `profile`;
DROP TABLE IF EXISTS `catitem`;
DROP TABLE IF EXISTS `userattr`;
DROP TABLE IF EXISTS `userattrprofile`;
DROP TABLE IF EXISTS `alert`;
DROP TABLE IF EXISTS `alertmsg`;
DROP TABLE IF EXISTS `bookmark`;
DROP TABLE IF EXISTS `catitem`;
DROP TABLE IF EXISTS `catprofile`;
DROP TABLE IF EXISTS `desktopitem`;
DROP TABLE IF EXISTS `profile`;
DROP TABLE IF EXISTS `profilealert`;
DROP TABLE IF EXISTS `profiledesktopitem`;
DROP TABLE IF EXISTS `profilethumb`;
DROP TABLE IF EXISTS `thumb`;
DROP TABLE IF EXISTS `userattr`;
DROP TABLE IF EXISTS `userattrprofile`;
DROP TABLE IF EXISTS `profilcache_posh`;
DROP TABLE IF EXISTS `admin_posh`;
DROP TABLE IF EXISTS `admin_sacoche`;
DROP TABLE IF EXISTS `admin_cdt`;
DROP TABLE IF EXISTS `admin_iconito`;
DROP TABLE IF EXISTS `admin_iconito`;
DROP TABLE IF EXISTS `admin_iconito_rne`;
DROP TABLE IF EXISTS `admin_gepi`;
DROP TABLE IF EXISTS `admin_balado`;
DROP TABLE IF EXISTS `admin_owncloud`;
DROP TABLE IF EXISTS `pia_posh`;



DROP PROCEDURE IF EXISTS ModifSynchoWP;
DELIMITER |

CREATE PROCEDURE ModifSynchoWP()
BEGIN
	DECLARE last_run INT;
	DECLARE purger_sentry INT;
	DECLARE purger_buddypress INT;

	-- si la table admin_wordpress_group n'existe pas
	SELECT count(*) INTO last_run FROM information_schema.tables WHERE table_schema = 'poshprofile' AND table_name = 'admin_wordpress_group' LIMIT 1;

	IF last_run = 0 THEN
		CREATE TABLE IF NOT EXISTS `admin_wordpress_group` (
			`id` int(11) NOT NULL AUTO_INCREMENT,
			`idsite` int(11) NOT NULL,
			`idsynchro` int(11) NOT NULL,
			`labelsynchro` varchar(255) NOT NULL,
			PRIMARY KEY (`id`)
			) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

		-- on alimente la table avec les données de la table admin_wordpress
		INSERT INTO admin_wordpress_group (idsite, idsynchro, labelsynchro) SELECT id, idsynchro, labelsynchro FROM `admin_wordpress`;

		UPDATE  admin_wordpress SET  role_notchange =  '1' WHERE  role_notchange IS NULL;
	END IF;


	-- on vérifie l'existence des champs purger_sentry et purger_buddypress dans la table admin_wordpress
	SELECT COUNT(column_name) INTO purger_sentry FROM INFORMATION_SCHEMA.COLUMNS WHERE table_name = 'admin_wordpress' AND column_name = 'purger_sentry';
	SELECT COUNT(column_name) INTO purger_buddypress FROM INFORMATION_SCHEMA.COLUMNS WHERE table_name = 'admin_wordpress' AND column_name = 'purger_buddypress';

	IF purger_sentry = 0 && purger_buddypress = 0 THEN
  		ALTER TABLE `admin_wordpress` ADD `purger_sentry` INT NOT NULL DEFAULT '0', ADD `purger_buddypress` INT NOT NULL DEFAULT '0';
	END IF;

END|
DELIMITER ;



-- Gestion du Menu -----------------------------------------------------------------------------------------------------------------------------------

-- Table des Entrées du Menu
DELETE FROM `admin_panel` WHERE admin_panel_alias='global' AND admin_panel_weburl='global';
DELETE FROM `admin_panel` WHERE admin_panel_alias='%%alias_poshprofil' AND admin_panel_weburl='%%web_url';

INSERT INTO `admin_panel` (`admin_panel_id`, `admin_panel_alias`, `admin_panel_weburl`, `admin_panel_label`, `admin_panel_url`, `admin_panel_order`, `admin_panel_group_id`) VALUES
(14,'global', 'global', 'Délégation', 'admin-delegation.php', 5, '10');

%if %%is_defined('poshprofil_typesynchro') and %%poshprofil_typesynchro == 'ENT'
%if %%is_defined('activer_limesurvey') and %%activer_limesurvey == 'oui'
INSERT INTO `admin_panel` (`admin_panel_id`, `admin_panel_alias`, `admin_panel_weburl`, `admin_panel_label`, `admin_panel_url`, `admin_panel_order`, `admin_panel_group_id`) VALUES
(25, '%%alias_poshprofil', '%%web_url', 'Limesurvey','synchro/limesurvey-admin.php',6,'20');
%end if
%if %%is_defined('activer_moodle') and %%activer_moodle == 'oui'
INSERT INTO `admin_panel` (`admin_panel_id`, `admin_panel_alias`, `admin_panel_weburl`, `admin_panel_label`, `admin_panel_url`, `admin_panel_order`, `admin_panel_group_id`) VALUES
(26, '%%alias_poshprofil', '%%web_url', 'Moodle','synchro/moodle-admin.php',7,'20');
%end if
%if %%is_defined('activer_nextcloud') and %%activer_nextcloud == 'oui'
INSERT INTO `admin_panel` (`admin_panel_id`, `admin_panel_alias`, `admin_panel_weburl`, `admin_panel_label`, `admin_panel_url`, `admin_panel_order`, `admin_panel_group_id`) VALUES
(27, '%%alias_poshprofil', '%%web_url', 'Nextcloud','synchro/nextcloud-admin.php',8,'20');
%end if
%if %%is_defined('activer_piwigo') and %%activer_piwigo == 'oui'
INSERT INTO `admin_panel` (`admin_panel_id`, `admin_panel_alias`, `admin_panel_weburl`, `admin_panel_label`, `admin_panel_url`, `admin_panel_order`, `admin_panel_group_id`) VALUES
(29, '%%alias_poshprofil', '%%web_url', 'Piwigo','synchro/piwigo-admin.php',10,'20');
%end if
%if %%is_defined('activer_wordpress') and %%activer_wordpress == 'oui'
INSERT INTO `admin_panel` (`admin_panel_id`, `admin_panel_alias`, `admin_panel_weburl`, `admin_panel_label`, `admin_panel_url`, `admin_panel_order`, `admin_panel_group_id`) VALUES
(32, '%%alias_poshprofil', '%%web_url', 'Wordpress','synchro/wordpress-admin.php',13,'20');
%end if
%end if

%if %%is_defined('poshprofil_typesynchro') and %%poshprofil_typesynchro == 'Annuaire'
%if %%is_defined('activer_limesurvey') and %%activer_limesurvey == 'oui'
INSERT INTO `admin_panel` (`admin_panel_id`, `admin_panel_alias`, `admin_panel_weburl`, `admin_panel_label`, `admin_panel_url`, `admin_panel_order`, `admin_panel_group_id`) VALUES
(21, '%%alias_poshprofil', '%%web_url', 'Limesurvey','pia/limesurvey-admin.php',2,'20');
%end if
%if %%is_defined('activer_moodle') and %%activer_moodle == 'oui'
INSERT INTO `admin_panel` (`admin_panel_id`, `admin_panel_alias`, `admin_panel_weburl`, `admin_panel_label`, `admin_panel_url`, `admin_panel_order`, `admin_panel_group_id`) VALUES
(22, '%%alias_poshprofil', '%%web_url', 'Moodle','pia/moodle-admin.php',3,'20');
%end if
%if %%is_defined('activer_piwik') and %%activer_piwik == 'oui'
INSERT INTO `admin_panel` (`admin_panel_id`, `admin_panel_alias`, `admin_panel_weburl`, `admin_panel_label`, `admin_panel_url`, `admin_panel_order`, `admin_panel_group_id`) VALUES
(23, '%%alias_poshprofil', '%%web_url', 'Piwik','pia/piwik-admin.php',4,'20');
%end if
%if %%is_defined('activer_wordpress') and %%activer_wordpress == 'oui'
INSERT INTO `admin_panel` (`admin_panel_id`, `admin_panel_alias`, `admin_panel_weburl`, `admin_panel_label`, `admin_panel_url`, `admin_panel_order`, `admin_panel_group_id`) VALUES
(25, '%%alias_poshprofil', '%%web_url', 'Wordpress','pia/wordpress-admin.php',5,'20');
%end if
%end if

-- Tables des Groupes de Menu
DELETE FROM `admin_panel_group` WHERE admin_panel_group_alias = '%%alias_poshprofil' AND admin_panel_group_weburl='%%web_url';
INSERT INTO `admin_panel_group` (`admin_panel_group_id`, `admin_panel_group_alias`, `admin_panel_group_weburl`,  `admin_panel_group_name`, `admin_panel_group_order`) VALUES
(10, '%%alias_poshprofil', '%%web_url', 'Permission', 2),
(20, '%%alias_poshprofil', '%%web_url', 'Synchronisation',3);


%if %%is_defined('poshprofil_typesynchro') and %%poshprofil_typesynchro == 'ENT'
-- Tables de Synchronisation ENT -------------------------------------------------------------------------------------------------------------------------

-- Table d'administration de synchronisation Wordpress
INSERT IGNORE INTO `admin_wordpress` (`id`, `synchro_user`, `del_user`, `perm_visiteur`, `perm_eleve`, `perm_responsable`, `perm_enseignant`, `perm_administratif`, `perm_administrateur`, `idsynchro`, `labelsynchro`) VALUES (1, 1, 1, 0, 1, 1, 3, 3, 5, '-1', 'Tout > Tout');
INSERT IGNORE INTO admin_wordpress_group (idsite, idsynchro, labelsynchro) SELECT id, idsynchro, labelsynchro FROM `admin_wordpress`;

-- Table d'administration de synchronisation Piwigo
INSERT IGNORE INTO `admin_piwigo` (`id`, `synchro_classe`, `synchro_user`, `del_classe`, `del_user`) VALUES (1, 1, 1, 1, 1);

-- Table d'administration de synchronisation Moodle
INSERT IGNORE INTO `admin_moodle` (`id`, `synchro_classe`, `synchro_user`, `del_classe`, `del_user`) VALUES (1, 1, 1, 1, 1);

-- Table d'administration de synchronisation nextcloud
INSERT IGNORE INTO `admin_nextcloud` (`id`, `quota`, `quota_eleve`, `quota_responsable`, `quota_enseignant`, `quota_administratif`, `quota_administrateur`) VALUES (1, 'none', 'default', 'default', 'default', 'default', 'default');

-- Table d'administration de synchronisation Limesurvey
INSERT IGNORE INTO `admin_limesurvey` (`id`, `synchro_classe`, `synchro_niveau`, `synchro_groupe`, `synchro_option`) VALUES (1, 1, 1, 1, 1);
%end if

%if %%is_defined('poshprofil_typesynchro') and %%poshprofil_typesynchro == 'Annuaire'
-- Tables de Synchronisation PIA -------------------------------------------------------------------------------------------------------------------------

-- Table d'administration de synchronisation Limesurvey
INSERT IGNORE INTO `pia_limesurvey` (`id`, `synchro_group`, `ldap_group`,`role_notchange`) VALUES (1, 0, "(&(cn=*)(objectClass=posixGroup))", 1);

-- Table d'administration de synchronisation piwik
INSERT IGNORE INTO `pia_piwik` (`id`, `synchro_user`, `ldap_user`, `ldap_view`, `ldap_admin`) VALUES (1, 0,"(&(uid=*)(objectClass=person))","","");

-- Table d'administration de synchronisation Moodle
INSERT IGNORE INTO `pia_moodle` (`id`, `synchro_group`, `synchro_user`, `del_group`, `del_user`, `ldap_group`, `ldap_user`, `ldap_prof`) VALUES (1, 0, 0, 1, 1, "(&(cn=*)(objectClass=posixGroup))", "(&(uid=*)(objectClass=person))", "(&(cn=Formateur)(objectClass=posixGroup))");

-- Table d'administration de synchronisation Wordpress
INSERT IGNORE INTO `pia_wordpress` (`id`, `synchro_user`, `del_user`, `ldap_abonne`, `ldap_contributeur`, `ldap_auteur`, `ldap_editeur`, `ldap_administrateur`, `ldap_user`, `role_notchange`) VALUES (1, 0, 0, '(uid=*)', '', '', '', '(uid=admin)', '(uid=#login#)', '1');
%end if