<?

	// On vérifie si le php est executé en ligne de commande
	if(!is_null($argv)) {
		$param=array('key'=>$argv[2]);
	}

	$PATH="../";
	include_once($PATH."include/include.php");
	include_once($PATH."include/admin.php");
	include_once($PATH."include/nextcloud.php");

	if($_SESSION['user_login']!="UserCron") include_once($PATH.$config["templatedir"]."/html.php");		/* Entete HTML		*/
	if($_SESSION['user_login']!="UserCron") include_once($PATH.$config["templatedir"]."/frame.php");	/* Entete HTML		*/


	$dbprf1=new ps_db;
	$dbown1=new ps_db;
    $dbown1->dbname($config["nextcloudhost"],"nextcloud",$config["nextcloudpwd"],"nextcloud");


//==FUNCTION===========================================================================================================================================
	function AfficheTitre($label) {
		if($_SESSION['user_login']!="UserCron") echo "<h1>$label</h1>"; else echo "\n*** ".strtoupper($label)." ***\n";
	}

	function AfficheLigne($label) {
		echo $label;
		if($_SESSION['user_login']!="UserCron") echo "<br>"; else echo "\n";
	}

	function AfficheLigneGras($label) {
		if($_SESSION['user_login']!="UserCron") echo "<strong>$label</strong><br>"; else echo ">> ".$label." \n";
	}

	function AfficheLigneSouligne($label) {
		if($_SESSION['user_login']!="UserCron") echo "<em>$label</em><br>"; else echo "* ".$label." \n";
	}


	// Determine en fonction du profil sso le profil wordpress
	function Profil($uid, $ENTProfil) {
		global $config;

		if($uid=="admin"){
			$role="administrateur";
		}
		else {
			switch($ENTProfil){
				case "eleve":
					$role="eleve";
					break;

				case "responsable":
				    $role="responsable";
					break;

				case "administratif":
                    $role="administratif";
					break;

				case "enseignant":
					switch($uid){
						case "Visiteur":	$role=""; break;
						case "Meta_eleve":	$role="eleve";break;
						case "Meta_parent":	$role="responsable";break;
						case "Meta_prof":	$role="enseignant";break;
						case "Meta_perdir":	$role="administratif";break;
						default : 			$role="enseignant";
					}
					break;

				case "administrateur":
					$role="administratif";
					break;

				case "visiteur":
				default :
					$role="";
					break;
			}
		}
        if (isset($config['uid_addadmin']))
        {
            if ($uid == $config['uid_addadmin']){
                $role="administrateur";
            }
        }

	    return $role;
	}



//==MAIN BLOCK=========================================================================================================================================

	$ds = ldap_connect ( $config['LDAPserver'], $config['LDAPport'] );
	if (!$ds) {
		AfficheLigne("Erreur : impossible de se connecter à l'annuaire LDAP");
		die();
	}

    ldap_set_option($ds, LDAP_OPT_PROTOCOL_VERSION, 3);
    ldap_set_option($ds, LDAP_OPT_REFERRALS, 0);

    if($config['LDAPtls']) {
        ldap_start_tls($ds);
    }
        
	$r=ldap_bind($ds,$config['LDAPreaderdn'],$config['LDAPreaderpw']);
    if (!$r) {
		AfficheLigne("Erreur authentification : impossible de se connecter à l'annuaire LDAP");
		die();
    }

	$dbprf1->query("SELECT * FROM admin_nextcloud WHERE id=1");
	if($dbprf1->next_record()) {
        $quota_notchange = $dbprf1->f("quota_notchange");

		// création/maj de tous les groupes (principaux et autres)
		AfficheLigne("");
		AfficheLigneGras("Définition des Quotas en fonction du profil de l'utilisateur");

        // Valoriser le quota par défaut
        shell_exec('php8.1 /var/www/html/nextcloud/occ config:app:set files default_quota --value "'.$dbprf1->f("quota").'"');

		$res = ldap_search($ds,$config['LDAPracine'],"(&(uid=*)(objectclass=inetOrgPerson)(!(description=Computer)))");
		for ($entryID=ldap_first_entry($ds,$res);$entryID!=false;$entryID=ldap_next_entry($ds,$entryID))
		{
			$uid		= ldap_get_values($ds,$entryID,'uid');
			@$mail		= ldap_get_values($ds,$entryID,'mail');
			@$ENTprofil	= ldap_get_values($ds,$entryID,'ENTPersonProfils');
            $quota      = "";
            $quotaow    = "default";

            $dbown1->query("SELECT * FROM oc_preferences WHERE userid='".$uid[0]."' AND appid='files' AND configkey='quota'");
            if($dbown1->next_record()) {
                $quotaow=$dbown1->f("configvalue");
            }

			switch(Profil($uid[0], $ENTprofil[0])) {	
                case "eleve":
                    $profil="eleve";
			        $quota=$dbprf1->f("quota_eleve");
			        break;
			
                case "enseignant":
                    $profil="enseigant";
    			    $quota=$dbprf1->f("quota_enseignant");
    			    break;
                
                case "responsable":
                    $profil="responsable";
    			    $quota=$dbprf1->f("quota_responsable");
    			    break;

                case "administratif":
                    $profil="administratif";
    			    $quota=$dbprf1->f("quota_administratif");
    			    break;

                case "administrateur":
                    $profil="administrateur";
    			    $quota=$dbprf1->f("quota_administrateur");
    			    break;
			}

			$flgchangequota=true;
            if($quota=="") $flgchangequota=false;
            if($quotaow!="default" && $quota_notchange) $flgchangequota=false;
                
            if($flgchangequota) {
                AfficheLigne("Utilisateur = ".$uid[0]." = $profil = $quotaow >> $quota");
                $dbown1->query("INSERT IGNORE INTO oc_preferences (userid,appid,configkey,configvalue) VALUES ('".$uid[0]."','files','quota','$quota')  ON DUPLICATE KEY UPDATE configvalue='$quota'");
            }
            else {
                AfficheLigne("Utilisateur = ".$uid[0]." = $profil = quotas préservé à $quotaow");
            }
		}
	}

	AfficheLigne("");
	AfficheLigneGras("Suppression des utilisateurs obsolètes");	
	$dbown1->query("SELECT * FROM oc_preferences WHERE appid='user_ldap' AND configkey='isDeleted' AND configvalue=1");
	while($dbown1->next_record()) {
		AfficheLigne("Utilisateur = ".$dbown1->f("userid"));
		$output = shell_exec('php8.1 /var/www/html/nextcoud/occ user:delete '.$dbown1->f("userid"));
		AfficheLigne($output);
		$dbown1->query("DELETE FROM oc_ldap_user_mapping WHERE owncloud_name='".$dbown1->f("userid")."'");
	}

	AfficheLigne("");
	AfficheLigneGras("Dévérouillage des fichiers");	
	$dbown1->query("UPDATE  oc_file_locks SET  `lock`=0");	

?>
