#!/bin/bash

for TEST_PHP_BIN in php5 php php-cli php-cgi; do
  if which $TEST_PHP_BIN >/dev/null 2>/dev/null; then
    PHP_BIN=`which $TEST_PHP_BIN`
    break
  fi
done

if test -z $PHP_BIN; then
  echo "php binary not found. Make sure php5 or php exists in PATH." >&2
  exit 1
fi

act_path() {
  local pathname="$1"
  readlink -f "$pathname" 2>/dev/null || \
  realpath "$pathname" 2>/dev/null || \
  type -P "$pathname" 2>/dev/null
}

ARCHIVE=`act_path ${0}`
PIWIK_CRON_FOLDER=`dirname ${ARCHIVE}`
PIWIK_PATH="$PIWIK_CRON_FOLDER/../.."

#$PHP_BIN $PIWIK_PATH/console plugin:deactivate CASLogin >/dev/null
#$PHP_BIN $PIWIK_PATH/console plugin:activate Login >/dev/null

$PHP_BIN $PIWIK_PATH/console core:archive -v --force-all-websites > $PIWIK_PATH/tmp/logs/cron-archive.log

#$PHP_BIN $PIWIK_PATH/console plugin:deactivate Login >/dev/null
#$PHP_BIN $PIWIK_PATH/console plugin:activate CASLogin >/dev/null

exit 1
