<?php
/**
 * Piwik - free/libre analytics platform
 *
 * @link http://piwik.org
 * @license http://www.gnu.org/licenses/gpl-3.0.html GPL v3 or later
 *
 */
namespace Piwik\Plugins\ServerStats;


use Piwik\Period;
use Piwik\Period\Range;
use Piwik\DataTable;
use Piwik\DataTable\Row;
use Piwik\Site;
use Piwik\Config;
use Piwik\Db;

/**
 * API for plugin ServerStats
 *
 * @method static \Piwik\Plugins\ServerStats\API getInstance()
 */
class API extends \Piwik\Plugin\API
{

    /**
     * Another example method that returns a data table.
     * @param int    $idSite
     * @param string $period
     * @param string $date
     * @param bool|string $segment
     * @return DataTable
     */
    public function getTypeEtab($idSite, $period, $date, $segment = false)
    {
        $period = Period\Factory::makePeriodFromQueryParams(Site::getTimezoneFor($idSite), $period, $date);
     
        $dateStart = $period->getDateStart()->toString('Y-m-d'); // eg. "2009-04-01"
        $dateEnd = $period->getDateEnd()->toString('Y-m-d'); // eg. "2009-04-30"*/

        //echo $idSite." ".$dateStart." 00:00:00 ".$dateEnd." 23:59:59";
        $queryTypes = "SELECT DISTINCT(custom_var_v8) FROM piwik_log_visit 
                       WHERE idsite= ? AND visit_first_action_time > ? AND visit_last_action_time < ?";
        $types = Db::fetchAll($queryTypes, array($idSite, $dateStart." 00:00:00", $dateEnd." 23:59:59"));

        
        $hits = new DataTable(); 
        foreach($types as $atypes)
        {
            $type = $atypes['custom_var_v8'];
            $queryHits = "SELECT COUNT(DISTINCT(custom_var_v1)) as nb_etabs FROM piwik_log_visit 
                          WHERE idsite= ? AND visit_first_action_time > ? AND visit_last_action_time < ? AND custom_var_v8= ?";
            $thits = Db::fetchAll($queryHits, array($idSite, $dateStart." 00:00:00", $dateEnd." 23:59:59", $type));
            
            $h1 = new Row(array(Row::COLUMNS => array('label'=>$type, 'nb_etabs'=>$thits[0]['nb_etabs']),));
            $hits->addRow($h1);
        }

        return $hits;
    }
}
