<?php
/**
 * Permet d'éditer un sondage de type date
 */
$all_days = $calendar->get_all_days(date('Y'), date('Y') + 5);
?>
<div class="alert alert-info">
	Sélectionnez une ou plusieurs dates.
</div>
<div class="autogrid5">
	<aside>
		<label for="">Année</label>
		<select class="list-years" name="year">
			<?php foreach ($all_days as $year => $months) : ?>
				<option value="<?php echo $year; ?>" <?php echo ($year == date('Y')) ?  'selected' : ''; ?>><?php echo $year; ?></option>
			<?php endforeach; ?>
		</select>
	</aside>
	<aside>
		<label for="">Mois</label>
		<select class="list-months" name="month">
			<?php foreach ($calendar->months as $i => $month) : ?>
				<option value="<?php echo $i+1; ?>" <?php echo ($i+1 == date('m')) ?  'selected' : ''; ?>><?php echo ucfirst($month); ?></option>
			<?php endforeach; ?>
		</select>
	</aside>
	<aside></aside>
	<aside></aside>
	<aside></aside>
</div>

<div class="line">
	<div class="mod left w100" id="showCalendar">
		<?php $jours_feries = $calendar->getHolidays(); ?>
		<?php foreach ($all_days as $year => $months) : ?>
			<?php foreach ($months as $month => $days) : ?>
				<div id="year-<?php echo $year; ?>-month-<?php echo $month; ?>" class="table-month">
					<table>
						<thead>
							<tr>
								<?php foreach ($calendar->days as $i => $day) : ?>
									<th class="day pa1"><?php echo ucfirst($day); ?></th>
								<?php endforeach; ?>
							</tr>
						</thead>
						<tr>
						<?php $end = end($days); foreach ($days as $i => $day) : ?>
							<?php if ($i == 1 AND $day != 1) : ?>
								<td colspan="<?php echo $day-1; ?>" class="empty"></td>
							<?php endif; ?>
							<?php if (isset($s_sondage['options'])) : ?>
							<td class="day pa1 <?php echo in_array(strtotime($year.'-'.$month.'-'.$i), $jours_feries) ? 'ferie' : '' ; ?> <?php echo (in_array(strtotime($year.'-'.$month.'-'.$i), $s_sondage['options'])) ? 'selected' : ''; ?>" data-target="<?php echo URL.'/saveDate'.'/'.$sondage->token.'/'.strtotime($year.'-'.$month.'-'.$i).'/'.(in_array(strtotime($year.'-'.$month.'-'.$i), $s_sondage['options']) ? 'remove' : 'add').'/edit'; ?>">
							<?php else : ?>
							<td class="day pa1 <?php echo in_array(strtotime($year.'-'.$month.'-'.$i), $jours_feries) ? 'ferie' : '' ; ?> <?php echo (in_array(strtotime($year.'-'.$month.'-'.$i), $s_sondage['options'])) ? 'selected' : ''; ?>" data-target="<?php echo URL.'/saveDate'.'/'.$sondage->token.'/'.strtotime($year.'-'.$month.'-'.$i).'/'.(in_array(strtotime($year.'-'.$month.'-'.$i), array()) ? 'remove' : 'add').'/edit'; ?>">
							<?php endif; ?>
								<?php echo ($day==6 || $day==7) ? '<span class="weekend">WE</span>' : '' ; ?>
								<span class="numDay"><?php echo $i; ?></span> 
								
							</td>
							<?php if ($day==7) : ?>
								</tr><tr>
							<?php endif; ?>
						<?php endforeach; ?>
						<?php if ($end != 7) : ?>
							<td colspan="<?php echo 7-$end; ?>" class="empty"></td>
						<?php endif; ?>
						</tr>
					</table>
				</div>
			<?php endforeach; ?>
		<?php endforeach; ?>
	</div>
</div>

<div id="hours">
	<div id="container">
	<?php $data = array(); ?>
	<?php foreach ($options as $k => $opt) :
		list($time, $hour) = explode('@', $opt->value);
		if (!isset($data[$time])) 
			$data[$time] = array();
		if (!isset($data[$time][$hour]))
			array_push($data[$time], $hour);
		endforeach;
	?>
	<section class="manageOptions mt1 mb1">
		<a href="#" class="reportHours mr1 btn btn-default">
			<i class="fa fa-repeat"></i> Répéter l'horaire
		</a>
		<a href="#" class="cleanAllHours btn btn-danger">
			<i class="fa fa-eraser"></i> Effacer
		</a>
	</section>

		<?php foreach ($data as $time => $hours) : ?>
			<div class="optionTime" id="time<?php echo $time; ?>">
				<p class="date">
					<span class="arrow-down"></span>
					<?php echo ucfirst(strftime('%A %d %B %G', $time)); ?>
				</p>
				<section class="autogrid5 timegrid" id="t<?php echo $time; ?> line<?php echo $k; ?>">
					<?php for ($i=0; $i<5; $i++) : ?>
						<div>
							<label for="input<?php echo $time; ?>">Horaire <?php echo $i+1; ?></label>
							<input type="text" class="hoursOptions hoursOptions<?php echo $i; ?>" id="input<?php echo $time; ?>" name="date[<?php echo $time; ?>][]" value="<?php echo !empty($hours[$i]) ? $hours[$i] : ''; ?>">
						</div>
					<?php endfor; ?>
				</section>
			</div>
		<?php endforeach; ?>
		</div>
</div>


