<?php
/**
 * This is core configuration file.
 *
 * Use it to configure Heimdall.
 *
 */



class Conf {

	/**
	 * Heimdall debug level
	 * 	Production mode:
	 * 		0: No error message 
	 * 	Developement mode:
	 * 		1: All error message without debug backtrace
	 * 		2: All error message with debug backtrace
	 * @var integer
	 */
	static $debug = 0; 

	/**
	 * Nom de l'application - Nom affiché dans les vues
	 * @var string
	 */
	static $nameApp = "OpenSondage";

	static $nameAppSlug = "opensondage";

	/**
	 * Défini l'adresse hôte de l'application
	 */
	static $web_url = "scribe23.ac-envole.fr";

	/**
	 * Nom de domaine mail qui doit être cassifié
	 * lorsqu'un utilisateur veut répondre à un sondage.
	 * @var string
	 */
	static $mail_to_CAS = "scribe23.ac-envole.fr"; 	

	/**
	 * Nom du theme couleur à utiliser pour l'application
	 * Le fichier CSS de theme doit respecter la syntaxe suivante:
	 * 		nom_du_theme.theme.css
	 * Par exemple ici: envole.theme.css
	 * @var string
	 */
    static $CSStheme = 'piadijon';
	
	/**
	 * Version de l'application
	 * @var string
	 */
	static $version = "1.0";

	/**
	 * Défini la limite du nombre de destinataire
	 * possible pour un sondage
	 * @var integer
	 */
	static $limDestinataire = 100;

	/**
	 * Défini la limite d'options possible pour les sondages de type "autre"
	 * @var integer
	 */
	static $limTexte = 100;

	/**
	 * Active ou non la librairie CAS
	 * @var integer
	 */
	static $CAS_enable = 1;

	/**
	 * Permet de choisir quelles actions d'un controller doit etre cassifiée
	 * @var array
	 */
	static $CAS_actions = array(
		'Sondages' => array(
			'index',
			'create',
			'options',
			'saveDate',
			'destinataires',
			'delete',
			'saveDate',
			'erase',
			'edit'
			)
		);

static $dbpwd="wohgetew";
	/**
	 * Databases configuration
	 * @var array
	 */
	static $databases = array(
		'default' => array(
			'host'		=> '127.0.0.1',
			'database'	=> 'opensondage',
			'login'		=> 'opensondage',
			//prefix  	=> '',
			//encode 	=> 'utf8'
		)
	);

}
?>
