<?php

namespace App\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use FOS\CKEditorBundle\Form\Type\CKEditorType;


class SurveystatusType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->add('submit',
            SubmitType::class, [
                "label" => ($options["status"]==1?"Envoyer le résultat et clôturer":"Réouvrir le sondage"),
                "attr" => ["class" => "btn btn-danger no-print"],
            ]
        );

        if($options["status"]==1) {
            $choices=[];
            foreach($options["result"] as $value) {
                $choices[$value["date"]->format("d/m/Y H:i")]=$value["id"];
            }
        

            $builder->add('isresult',
                ChoiceType::class, [
                    "label" => "Résultat retenu ?",
                    "mapped" => false,
                    "choices" => $choices,
                ]
            );
        }
        $builder->add('tonotifymessage',
            CKEditorType::class, [
                "label" => "Message envoyé",
                "required" => true,
                "config" => [
                    'uiColor' => '#ffffff',
                    'height' => 250,
                    'filebrowserUploadRoute' => 'app_ckeditor_upload',
                    'language' => 'fr',
                ],
            ]
        );
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => 'App\Entity\Survey',
            'result' => 'string',
            'status' => 'string'
        ]);
    }
}
