<?php
namespace App\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;


class SurveyguestType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->add('jsonsurveyvotes', 
            HiddenType::class, [
                'label' => 'jsonsurveyvotes',
                'required' => false,
                'empty_data' => '',                  
            ]
        );
    
        if($options['status']==0) {
            $builder->add('submit',
                SubmitType::class, [
                    "label" => "Valider",
                    "attr" => ["class" => "btn btn-success no-print"],
                ]
            );
        }
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class'    => 'App\Entity\Surveyguest',
            'status'        => 'string',
        ));
    }
}
