<?php

namespace App\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;


class QuestkeyType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->add('submit',
            SubmitType::class, [
                "label" => "Voter",
                "attr" => ["class" => "btn btn-success no-print"],
            ]
        );

        $builder->add('email',
            EmailType::class, [
                "label" =>"Email",
            ]
        );
        
        $builder->add('displayname',
            TextType::class, [
                "label" =>"Nom Prénom",
                "attr" => ["autocomplete" => "off"],
            ]
        );

    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => 'App\Entity\Questguest',
        ]);
    }
}
