<?php

namespace App\Entity;

use App\Repository\QuestoptionRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass=QuestoptionRepository::class)
 * @ORM\Table(name="`questoption`")
 */
class Questoption
{
    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(name="code", type="integer")
     */
    private $code;

    /**
     * @ORM\Column(name="roworder", type="integer")
     */
    private $roworder;

    /**
     * @ORM\Column(name="name", type="string")
     */
    private $name;

    /**
     * @ORM\Column(name="required", type="boolean")
     */
    private $required;

    /**
     * @ORM\Column(name="type", type="integer")
     */
    private $type;

    /**
     * @ORM\Column(name="parameters", type="json")
     */
    private $parameters;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\Questvote", mappedBy="questoption", cascade={"persist"}, orphanRemoval=true)
     */
    private $questvotes;
    
    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\Quest", inversedBy="questoptions")
     */
    private $quest;

    public function __construct()
    {
        $this->questvotes = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getCode(): ?int
    {
        return $this->code;
    }

    public function setCode(int $code): self
    {
        $this->code = $code;

        return $this;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getRequired(): ?bool
    {
        return $this->required;
    }

    public function setRequired(bool $required): self
    {
        $this->required = $required;

        return $this;
    }

    public function getType(): ?int
    {
        return $this->type;
    }

    public function setType(int $type): self
    {
        $this->type = $type;

        return $this;
    }

    public function getParameters(): ?array
    {
        return $this->parameters;
    }

    public function setParameters(array $parameters): self
    {
        $this->parameters = $parameters;

        return $this;
    }

    /**
     * @return Collection|Questvote[]
     */
    public function getQuestvotes(): Collection
    {
        return $this->questvotes;
    }

    public function addQuestvote(Questvote $questvote): self
    {
        if (!$this->questvotes->contains($questvote)) {
            $this->questvotes[] = $questvote;
            $questvote->setQuestoption($this);
        }

        return $this;
    }

    public function removeQuestvote(Questvote $questvote): self
    {
        if ($this->questvotes->removeElement($questvote)) {
            // set the owning side to null (unless already changed)
            if ($questvote->getQuestoption() === $this) {
                $questvote->setQuestoption(null);
            }
        }

        return $this;
    }

    public function getQuest(): ?Quest
    {
        return $this->quest;
    }

    public function setQuest(?Quest $quest): self
    {
        $this->quest = $quest;

        return $this;
    }

    public function getRoworder(): ?int
    {
        return $this->roworder;
    }

    public function setRoworder(int $roworder): self
    {
        $this->roworder = $roworder;

        return $this;
    }

}
