<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Form\FormError;
use App\Form\CreateSurveyFlow;
use Ramsey\Uuid\Uuid;


use App\Entity\Survey;
use App\Entity\Surveyoption;
use App\Entity\Surveyguest;
use App\Entity\Surveyvote;

use App\Form\SurveyguestType as SurveyguestType;
use App\Form\SurveykeyType as SurveykeyType;
use App\Form\SurveystatusType as SurveystatusType;

class SurveyController extends AbstractController
{
    public function list()
    {
        $surveyguests=$this->getUser()->getSurveyguests();
        return $this->render('Survey/survey.html.twig', [
            'useheader'     => true,
            'usesidebar'    => false,                 
            'surveyguests'  => $surveyguests,
        ]);
    }

    public function submit(CreateSurveyFlow $flow)
    {
        $em = $this->getDoctrine()->getManager();
        $key = Uuid::uuid4();
        $survey = new Survey();
        $survey->setUser($this->getUser());
        $survey->setKey($key);
        $survey->setPrivate(true);
        $survey->setNotification(true);
        $survey->setStatus(0);
        $survey->setTonotifyclose(false);
        $survey->setTonotifyopen(false);

        $flow->bind($survey);
        $form = $flow->createForm();
        
        $return = $this->edit($flow,$form,$survey);

        if($return) return $this->redirect($this->generateUrl('app_survey'));

        return $this->render('Survey/edit.html.twig',[
            'useheader'         => true,
            'usesidebar'        => false,
            'form'              => $form->createView(),
            'flow'              => $flow,
            'survey'            => $survey,
        ]);        
    }
    
    public function update($id,CreateSurveyFlow $flow)
    {
        $em = $this->getDoctrine()->getManager();
        $survey=$em->getRepository("App:Survey")->find($id);

        // Construction de la chaine jsonsurveyoptions
        $surveyoptions=$em->getRepository("App:Surveyoption")->findBy(["survey"=>$survey],["date"=>"ASC"]);
        $tbdates=[];
        foreach($surveyoptions as $surveyoption) {
            $date=$surveyoption->getDate()->format("Y-m-d");
            $hour=$surveyoption->getDate()->format("H : i");

            if(!array_key_exists($date,$tbdates)) {
                $tbdates[$date]=["date"=>$date,"hours"=>[]];
            }

            if(!in_array($hour,$tbdates[$date]["hours"])) array_push($tbdates[$date]["hours"],$hour);
        }

        $jsonsurveyoptions="[";
        $i=0;
        foreach($tbdates as $date) {
            if($i>0) $jsonsurveyoptions.=",";
            $jsonsurveyoptions.=json_encode($date);
            $i++;
            
        }
        $jsonsurveyoptions.="]";
        $survey->setJsonsurveyoptions($jsonsurveyoptions);

        // Construction de la chaine jsonsurveyguests
        $surveyguests=$em->getRepository("App:Surveyguest")->findBy(["survey"=>$survey],["email"=>"ASC"]);
        $tbsurveyguests=[];
        foreach($surveyguests as $surveyguest) {
            array_push($tbsurveyguests,$surveyguest->getEmail());
        }
        $survey->setJsonsurveyguests(json_encode($tbsurveyguests));


        $flow->bind($survey);
        $form = $flow->createForm();

        $return = $this->edit($flow,$form,$survey);
        if($return) return $this->redirect($this->generateUrl('app_survey'));
        
        return $this->render('Survey/edit.html.twig',[
            'useheader'         => true,
            'usesidebar'        => false,
            'form'              => $form->createView(),
            'flow'              => $flow,
            'survey'            => $survey,
            'id'                => $id,
        ]);        
    }

    private function edit(CreateSurveyFlow &$flow,&$form,$survey)
    {
        $em = $this->getDoctrine()->getManager();

        // On s'assure que le survey appartient bien à l'utilisateur
        if($this->getUser()!=$survey->getUser()) {
            return $this->redirect($this->generateUrl('app_survey'));
        }

        if ($flow->isValid($form)) {
            // Controle de validité étape surveyoptions
            if($flow->getCurrentStepNumber()=="2") {
                $data=$form->getData();

                $jsonsurveyoptions=$data->getJsonsurveyoptions();
                if(!$jsonsurveyoptions||$jsonsurveyoptions=="[]") {
                    $form->addError(new FormError("Votre sondage doit comporter au minimum un horaire")); 
                }
               
                
                $errors = $form->getErrors();
                foreach( $errors as $error ) {
                    $this->get('session')->getFlashBag()->add("error", $error->getMessage());
                }
            }

            // Controle de validité étape surveyguests
            if($flow->getCurrentStepNumber()=="3") {
                $data=$form->getData();

                if($survey->getPrivate()) {
                    $jsonsurveyguests=$data->getJsonsurveyguests();
                    if(!$jsonsurveyguests||$jsonsurveyguests=="[]") {
                        $form->addError(new FormError("Votre sondage doit comporter au minimum un invité")); 
                    }

                    $errors = $form->getErrors();
                    foreach( $errors as $error ) {
                        $this->get('session')->getFlashBag()->add("error", $error->getMessage());
                    }
                }
            }


            if($form->isValid($form)) {
                $flow->saveCurrentStepData($form);
                
                if ($flow->nextStep()) {
                    $form = $flow->createForm();
                } else {
                    // Sauvegarde du sondage
                    $em->persist($survey);
                    
                    // Sauvegarde des surveyoptions
                    $data=$form->getData();
                    $jsonsurveyoptions=json_decode($data->getJsonsurveyoptions());
                    $tbsurveyoptions=[];
                    foreach($jsonsurveyoptions as $date) {
                        foreach($date->hours as $hour ) {
                            $hour=str_replace(" ","",$hour);
                            $datesurveyoption= new \DateTime($date->date." ".$hour);
                            array_push($tbsurveyoptions,$datesurveyoption);
                            
                            $surveyoption=$em->getRepository("App:Surveyoption")->findOneBy(["date"=>$datesurveyoption,"survey"=>$survey]);
                            if(!$surveyoption) {
                                $surveyoption=new Surveyoption();
                                $surveyoption->setDate($datesurveyoption);
                                $surveyoption->setSurvey($survey);
                                $surveyoption->setChoiced(false);
                                $em->persist($surveyoption);
                            }
                        }
                    }

                    // Sauvegarde des invités
                    if($survey->getPrivate()) {
                        $data=$form->getData();
                        $jsonsurveyguest=json_decode($data->getJsonsurveyguests());
                        $tbsurveyguests=[];

                        // On ajoute le propriétaire du sondage en tant qu'invité si ce n'est pas le cas
                        if(!in_array($this->getUser()->getEmail(),$jsonsurveyguest)) array_push($jsonsurveyguest,$this->getUser()->getEmail());
                    
                        foreach($jsonsurveyguest as $email) {
                            array_push($tbsurveyguests,$email);
                            $user=$em->getRepository("App:User")->findOneBy(["email"=>$email]);

                            $surveyguest=$em->getRepository("App:Surveyguest")->findOneBy(["email"=>$email,"survey"=>$survey]);
                            if(!$surveyguest) {
                                $key = Uuid::uuid4();
                                $displayname=$email;
                                $tonotifyguest=true;
                                if($user) {
                                    $displayname=$user->getDisplayname();
                                    $tonotifyguest=($user!=$this->getUser());
                                }

                                $surveyguest=new Surveyguest();
                                $surveyguest->setEmail($email);
                                $surveyguest->setDisplayname($displayname);
                                $surveyguest->setKey($key);
                                $surveyguest->setSurvey($survey);
                                $surveyguest->setTonotifyguest($tonotifyguest);
                                $surveyguest->setTonotifyowner(false);
                            }
                            $surveyguest->setUser($user);
                            $em->persist($surveyguest);

                        }

                        // Suppression des invités obsolète
                        $surveyguests=$survey->getSurveyguests();
                        foreach($surveyguests as $surveyguest) {
                            if(!in_array($surveyguest->getEmail(),$tbsurveyguests)) {
                                $em->remove($surveyguest);
                            }
                        }
                    } 
                    else {
                        // On ajoute qu'il arrive le propriétaire en tant qu'invité
                        $surveyguest=$em->getRepository("App:Surveyguest")->findOneBy(["email"=>$this->getUser()->getEmail(),"survey"=>$survey]);
                        if(!$surveyguest) {
                            $key = Uuid::uuid4();
                            $surveyguest=new Surveyguest();
                            $surveyguest->setEmail($this->getUser()->getEmail());
                            $surveyguest->setDisplayname($this->getUser()->getDisplayname());
                            $surveyguest->setKey($key);
                            $surveyguest->setSurvey($survey);
                            $surveyguest->setTonotifyguest(false);
                            $surveyguest->setTonotifyowner(false);
                        }                        
                        $surveyguest->setUser($this->getUser());
                        $em->persist($surveyguest);
                    }

                    $em->flush();
                    $flow->reset();
                    return true;
                }   
            }
        }

        return false;
    }

    public function delete($id,Request $request)
    {
        // Initialisation de l'enregistrement
        $em = $this->getDoctrine()->getManager();
        $survey=$em->getRepository("App:Survey")->find($id);

        // On s'assure que le survey appartient bien à l'utilisateur
        if($this->getUser()!=$survey->getUser()) {
            return $this->redirect($this->generateUrl('app_survey'));
        }
        
        // Suppression
        $em->remove($survey);
        $em->flush();

        return $this->redirect($this->generateUrl('app_survey'));
    } 

    public function closeopen($id,$status,Request $request) {
        // Initialisation de l'enregistrement
        $em = $this->getDoctrine()->getManager();
        $survey=$em->getRepository("App:Survey")->find($id);

        // On s'assure que le survey appartient bien à l'utilisateur
        if($this->getUser()!=$survey->getUser()) {
            return $this->redirect($this->generateUrl('app_survey'));
        }

        $modalclose=false;
        $survey->setStatus($status);
        
        if($status==1) {
            $survey->setTonotifyclose(true);
            $survey->setTonotifymessage("Bonjour,<br><br>Après sondage la date suivante a été retenue pour notre réunion : <b>".$survey->getTitle()."</b><br><br><strong>#DATE#</strong><br><br>Merci de votre présence.<br><br>Vous pouvez consulter les réponses au sondage via le lien ci-après: <a href='#LINK#'>accéder au sondage</a><br><br>Cordialement<br>".$survey->getUser()->getDisplayname());
        }
        else {
            $survey->setTonotifyopen(true);
            $survey->setTonotifymessage("Bonjour,<br><br>Le sondage suivant a été réouvert : <b>".$survey->getTitle()."</b><br><br>Vous pouvez de nouveau répondre au sondage via le lien ci-après: <a href='#LINK#'>accéder au sondage</a>.<br><br>Cordialement<br>".$survey->getUser()->getDisplayname());
        }

        // Création du formulaire
        $form = $this->createForm(SurveystatusType::class,$survey,array("result"=>$survey->getResult(),"status"=>$status));

        // Récupération des data du formulaire
        $form->handleRequest($request);

        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {  
            $data = $form->getData();  

            // Pour chaque surveyoptions du suvery les placer comme non choisie
            $surveyoptions=$em->getRepository("App:Surveyoption")->findBy(["survey"=>$survey]);
            foreach($surveyoptions as $surveyoption) {
                $surveyoption->setChoiced(false);
                $em->persist($surveyoption);
                $em->flush();                
            }

            // Placer surveyoption selectionné comme choisie
            if($status==1) {
                $isresult=$form->get("isresult")->getData();

                $surveyoption=$em->getRepository("App:Surveyoption")->find($isresult);
                if($surveyoption) {
                    $surveyoption->setChoiced(true);
                    $em->persist($surveyoption);
                    $em->flush();                
                }
            }
            
            $em->persist($data);
            $em->flush();

            // Retour à la liste
            $modalclose=true;
        }

        return $this->render('Survey/status.html.twig',[
            'useheader'         => false,
            'usesidebar'        => false,
            'form'              => $form->createView(),
            'modalclose'        => $modalclose,
        ]);        
    }

    public function byuserkey($key,Request $request)
    {
        $em = $this->getDoctrine()->getManager();

        // Recherche de l'utilisateur dans le sondage
        $surveyguest = $em->getRepository("App:Surveyguest")->findOneBy(["survey"=>$key,"user"=>$this->getUser()]);
        if(!$surveyguest) {
            return $this->render('Response/nokey.html.twig',[
                'useheader'         => true,
                'usesidebar'        => false,
            ]);
        }            

        $return = $this->surveyvote($request,$form,$surveyguest,"byuserkey");
        if($return) return $this->redirect($this->generateUrl('app_survey'));

        return $this->render('Response/surveyvote.html.twig',[
            'useheader'         => true,
            'usesidebar'        => false,
            'surveyguest'       => $surveyguest,
            'form'              => $form->createView(),
            'by'                => "byuserkey",
        ]);
    }

    public function byguestkey($key,Request $request)
    {
        $em = $this->getDoctrine()->getManager();

        // Recherche de la clé d'invitation
        $surveyguest = $em->getRepository("App:Surveyguest")->findOneBy(["key"=>$key]);

        if(!$surveyguest) {
            return $this->render('Response/nokey.html.twig',[
                'useheader'         => true,
                'usesidebar'        => false,
            ]);
        }            

        $this->surveyvote($request,$form,$surveyguest,"bysurveyguestkey");

        return $this->render('Response/surveyvote.html.twig',[
            'useheader'         => true,
            'usesidebar'        => false,
            'surveyguest'             => $surveyguest,
            'form'              => $form->createView(),
            'by'                => "byguestkey",
        ]);
    }

    public function bysurveykey($key,Request $request)
    {
        $em = $this->getDoctrine()->getManager();

        // Recherche de la clé d'invitation
        $survey = $em->getRepository("App:Survey")->findOneBy(["key"=>$key]);
        if(!$survey) {
            return $this->render('Response/nokey.html.twig',[
                'useheader'         => true,
                'usesidebar'        => false,
            ]);
        }   

        // S'assurer que le sondage est public
        if($survey->getPrivate()) {
            return $this->render('Response/nokey.html.twig',[
                'useheader'         => true,
                'usesidebar'        => false,
            ]);
        }

        // Si la personne est déjà connectée : on génère une invitation et on le redirige via un accès user
        if($this->getUser()) {
            $surveyguest = $em->getRepository("App:Surveyguest")->findOneBy(["survey"=>$survey,"user"=>$this->getUser()]);
            if(!$surveyguest) {
                $key = Uuid::uuid4();
                $email=$this->getUser()->getEmail();
                $displayname=$this->getUser()->getDisplayname();
                $tonotifyguest=true;

                $surveyguest=new Surveyguest();
                $surveyguest->setEmail($email);
                $surveyguest->setDisplayname($displayname);
                $surveyguest->setKey($key);
                $surveyguest->setSurvey($survey);
                $surveyguest->setTonotifyguest($tonotifyguest);
                $surveyguest->setTonotifyowner(false);
                $surveyguest->setUser($this->getUser());
                $em->persist($surveyguest);
                $em->flush();                
            }

            return $this->redirect($this->generateUrl('app_survey_byuserkey',["key"=>$survey->getId()])); 
        }
        

        // Initialisation de l'enregistrement
        $data = new Surveyguest();

        // Création du formulaire
        $form = $this->createForm(SurveykeyType::class,$data);

        // Récupération des data du formulaire
        $form->handleRequest($request);

        // S'assurer que la personne n'a pas déjà voté
        // Si c'est le cas il ne devrait plus utiliser cette url
        // On lui retourne l'url associé à son surveyvote
        if ($form->get('submit')->isClicked()) {
            $data = $form->getData();  
            $email=$data->getEmail();
            $surveyguest=$em->getRepository("App:Surveyguest")->findOneBy(["survey"=>$survey,"email"=>$email]);
            if($surveyguest) {
               $surveyguest->setTonotifyguest(true);
               $em->persist($surveyguest);
               $em->flush(); 
               
               // Initialiser l'erreur
               $form->addError(new FormError("Une personne a déjà utiliser ce mail pour répondre au sondage.<br>Si vous êtes cette personne vous allez recevoir un mail vous indiquant l'url d'accès pour modifier ou visualiser votre réponse"));
               $this->get('session')->getFlashBag()->clear();
               $errors = $form->getErrors();
               foreach( $errors as $error ) {
                   $request->getSession()->getFlashBag()->add("error", $error->getMessage());
               }               
            }
        }
        
        if ($form->get('submit')->isClicked()&&$form->isValid()) {
            $user=$em->getRepository("App:User")->findOneBy(["email"=>$email]);

            $surveyguest=$em->getRepository("App:Surveyguest")->findOneBy(["email"=>$email,"survey"=>$survey]);
            if(!$surveyguest) {
                $key = Uuid::uuid4();
                $displayname=$data->getDisplayname();
                $tonotifyguest=true;

                $surveyguest=new Surveyguest();
                $surveyguest->setEmail($email);
                $surveyguest->setDisplayname($displayname);
                $surveyguest->setKey($key);
                $surveyguest->setSurvey($survey);
                $surveyguest->setTonotifyguest($tonotifyguest);
                $surveyguest->setTonotifyowner(false);
            }
            $surveyguest->setUser($user);
            $em->persist($surveyguest);
            $em->flush();

            return $this->redirect($this->generateUrl('app_survey_byguestkey',["key"=>$surveyguest->getKey()])); 
        }

        return $this->render('Survey/bysurveykey.html.twig',[
            'useheader'         => false,
            'usesidebar'        => false,
            'survey'            => $survey,
            'key'               => $key,
            'form'              => $form->createView(),
        ]);
    }    

    public function byloginkey($key,Request $request) {
        $em = $this->getDoctrine()->getManager();

        // Recherche de la clé d'invitation
        $survey = $em->getRepository("App:Survey")->findOneBy(["key"=>$key]);
        if(!$survey) {
            return $this->render('Response/nokey.html.twig',[
                'useheader'         => true,
                'usesidebar'        => false,
            ]);
        }   

        // S'assurer que le sondage est public
        if($survey->getPrivate()) {
            return $this->render('Response/nokey.html.twig',[
                'useheader'         => true,
                'usesidebar'        => false,
            ]);
        }

        // Si la personne est déjà connectée : on génère une invitation et on le redirige via un accès user
        if($this->getUser()) {
            $surveyguest = $em->getRepository("App:Surveyguest")->findOneBy(["survey"=>$survey,"user"=>$this->getUser()]);
            if(!$surveyguest) {
                $key = Uuid::uuid4();
                $email=$this->getUser()->getEmail();
                $displayname=$this->getUser()->getDisplayname();
                $tonotifyguest=true;

                $surveyguest=new Surveyguest();
                $surveyguest->setEmail($email);
                $surveyguest->setDisplayname($displayname);
                $surveyguest->setKey($key);
                $surveyguest->setSurvey($survey);
                $surveyguest->setTonotifyguest($tonotifyguest);
                $surveyguest->setTonotifyowner(false);
                $surveyguest->setUser($this->getUser());
                $em->persist($surveyguest);
                $em->flush();                
            }

            return $this->redirect($this->generateUrl('app_survey_byuserkey',["key"=>$survey->getId()])); 
        }        

        return $this->render('Response/nokey.html.twig',[
            'useheader'         => true,
            'usesidebar'        => false,
        ]);
    }

    private function surveyvote(&$request,&$form,&$surveyguest,$by) {
        $em = $this->getDoctrine()->getManager();

        // Construction de la chaine jsonsurveyvotes
        $surveyoptions=$em->getRepository("App:Surveyoption")->findBy(["survey"=>$surveyguest->getSurvey()],["date"=>"ASC"]);
        $tbsurveyvotes=[];
        foreach($surveyoptions as $surveyoption) {
            $id=$surveyoption->getId();

            if(!array_key_exists($id,$tbsurveyvotes)) {
                $tbsurveyvotes[$id]=["id"=>$id,"val"=>""];
            }

            $surveyvote=$em->getRepository("App:Surveyvote")->findOneBy(["surveyguest"=>$surveyguest,"surveyoption"=>$surveyoption]);
            if($surveyvote)
            $tbsurveyvotes[$id]["val"]=(!is_null($surveyvote->getVote())?$surveyvote->getVote():"");
        }

        $jsonsurveyvotes="[";
        $i=0;
        foreach($tbsurveyvotes as $surveyvote) {
            if($i>0) $jsonsurveyvotes.=",";
            $jsonsurveyvotes.=json_encode($surveyvote);
            $i++;
            
        }
        $jsonsurveyvotes.="]";
        $surveyguest->setJsonsurveyvotes($jsonsurveyvotes);

        // Création du formulaire
        $form = $this->createForm(SurveyguestType::class,$surveyguest,["status"=>$surveyguest->getSurvey()->getStatus()]);

        // Récupération des data du formulaire
        $form->handleRequest($request);
        
        // Si validation
        if($surveyguest->getSurvey()->getStatus()==0) {
            if ($form->get('submit')->isClicked() && $form->isValid()) {
                $data=$form->getData();
                $jsonsurveyvotes=json_decode($data->getJsonsurveyvotes());
                foreach($jsonsurveyvotes as $tosurveyvote) {
                    $surveyoption=$em->getRepository("App:Surveyoption")->find($tosurveyvote->id);
                    if($surveyoption) {
                        $surveyvote=$em->getRepository("App:Surveyvote")->findOneBy(["surveyguest"=>$surveyguest,"surveyoption"=>$surveyoption]);
                        if(!$surveyvote) {
                            $surveyvote= new Surveyvote();
                            $surveyvote->setSurveyguest($surveyguest);
                            $surveyvote->setSurveyoption($surveyoption);
                        }

                        $surveyvote->setVote($tosurveyvote->val==""?null:$tosurveyvote->val);
                        $em->persist($surveyvote);
                        $em->flush();
                    }
                }

                // Si le surveyvote n'est pas celui du propriétaire : on positionne le flag de notification du owner
                if($surveyguest->getUser()!=$surveyguest->getSurvey()->getUser()) {
                    $surveyguest->setTonotifyowner(true);
                    $em->persist($surveyvote);
                    $em->flush();
                }

                if($by=="byuserkey") return true;
                $this->get('session')->getFlashBag()->add("notice", "Votre vote a bien été prise en compte.<br>Vous pouvez à tout moment modifier votre vote via le lien qui vous a été transmis par mail.");
            }
        }
        else 
            $this->get('session')->getFlashBag()->add("notice", "Ce sondage est clos, voici les résultats des votes");

        return false;
    }
}
