<?php
namespace App\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Filesystem\Filesystem;
use Symfony\Component\Routing\RouterInterface;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;

class PurgeSurveyCommand extends Command
{
    private $container;
    private $em;
    private $output;
    private $filesystem;
    private $rootlog;
    private $router;
    private $mail;
    private $weburl;
    private $alias;
    private $noreply;

    public function __construct(ContainerInterface $container,EntityManagerInterface $em, RouterInterface $router)
    {
        parent::__construct();
        $this->container = $container;
        $this->em = $em;
        $this->router=$router;
    }

    protected function configure()
    {
        $this
            ->setName('app:purgeSurvey')
            ->setDescription("Suppression des sondages obsolètes")
            ->setHelp("Suppression des sondages obsolètes")
            ->addArgument('cronid', InputArgument::OPTIONAL, 'ID Cron Job') 
            ->addArgument('lastchance', InputArgument::OPTIONAL, 'Lastchance to run the cron')            
        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->output       = $output;
        $this->filesystem   = new Filesystem();
        $this->rootlog      = $this->container->get('kernel')->getLogDir()."/";
        
        $this->writelnred('');
        $this->writelnred('== app:purgeSurvey');        
        $this->writelnred('==========================================================================================================');

        $now=new \DateTime();
        $surveys=$this->em->getRepository("App:Survey")->findAll();
        foreach($surveys as $survey) {
            $datepurge=$survey->getDatepurge();
            if($datepurge<$now) {
                $this->writeln($survey->getTitle()." ".$survey->getDatepurge()->format("d/m/Y H:i"));
                $this->em->remove($survey);
                $this->em->flush();
            }
        }


        $this->writeln('');
        return 1;
    }

    private function writelnred($string) { 
        $this->output->writeln('<fg=red>'.$string.'</>');
        $this->filesystem->appendToFile($this->rootlog.'cron.log', $string."\n");
    }
    private function writeln($string) { 
        $this->output->writeln($string);
        $this->filesystem->appendToFile($this->rootlog.'cron.log', $string."\n");
    }   



}
