<?php

namespace App\Command;

use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Asset\Packages;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\Filesystem\Filesystem;
use Symfony\Component\Finder\Finder;

class PurgeFileCommand extends Command
{
    private $container;
    private $em;
    private $output;
    private $filesystem;
    private $rootlog;
    private $byexec;
    private $packages;

    public function __construct(ContainerInterface $container, EntityManagerInterface $em, Packages $packages)
    {
        parent::__construct();
        $this->container = $container;
        $this->em = $em;
        $this->packages = $packages;
    }

    protected function configure()
    {
        $this
            ->setName('app:purgeFile')
            ->setDescription('Suppression des fichier obsolètes')
            ->setHelp('Suppression des fichier obsolètes')
            ->addArgument('cronid', InputArgument::OPTIONAL, 'ID Cron Job')
            ->addArgument('lastchance', InputArgument::OPTIONAL, 'Lastchance to run the cron')
        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->output = $output;
        $this->filesystem = new Filesystem();
        $this->rootlog = $this->container->get('kernel')->getLogDir().'/';

        $this->writelnred('');
        $this->writelnred('== app:purgeFile');
        $this->writelnred('==========================================================================================================');

        $now = new \DateTime('now');

        // /uploads/document/activity
        $this->writelnred('');
        $this->writelnred('== Directory = Activity');
        $this->purgeDocuemnt('activity');

        // /uploads/document/corrected
        $this->writelnred('');
        $this->writelnred('== Directory = Corrected');
        $this->purgeDocuemnt('corrected');

        // /uploads/document/answer
        $this->writelnred('');
        $this->writelnred('== Directory = Answer');
        $this->purgeDocuemnt('answer');

        // /uploads/document/answercorrected
        $this->writelnred('');
        $this->writelnred('== Directory = Answercorrected');
        $this->purgeDocuemnt('answercorrected');

        // /public/uploads/avatar
        $this->writelnred('');
        $this->writelnred('== Directory = Avatar');

        $directory = $this->container->get('kernel')->getProjectDir().'/public/uploads/avatar';
        $this->writeln($directory);

        $files = [];
        $fs = new Filesystem();

        if ($fs->exists($directory)) {
            $finder = new Finder();
            $finder->in($directory)->files();

            foreach (iterator_to_array($finder) as $file) {
                $name = $file->getRelativePathname();
                if ('admin.jpg' != $name && 'noavatar.png' != $name && 'system.jpg' != $name) {
                    $entity = $this->em->getRepository('App:User')->findBy(['avatar' => $name]);
                    if (!$entity) {
                        $this->writeln($name);
                        $url = $directory.'/'.$name;
                        if ($fs->exists($url)) {
                            $fs->remove($url);
                        }
                    }
                }
            }
        }

        $fs = new Filesystem();
        $users = $this->em->getRepository('App:User')->findAll();
        foreach ($users as $user) {
            if (!$fs->exists($directory.'/'.$user->getAvatar())) {
                $this->writeln($user->getUsername());
                $user->setAvatar('noavatar.png');
                $this->em->persist($user);
                $this->em->flush();
            }
        }

        // /public/uploads/ckeditor
        $this->writelnred('');
        $this->writelnred('== Directory = Ckeditor');
        $directory = $this->container->get('kernel')->getProjectDir().'/public/uploads/ckeditor';
        $this->writelnred($directory);

        $files = [];
        $fs = new Filesystem();

        if ($fs->exists($directory)) {
            $finder = new Finder();
            $finder->in($directory)->files();

            foreach (iterator_to_array($finder) as $file) {
                $name = $file->getRelativePathname();
                $tofind = $this->packages->getUrl('uploads/ckeditor/'.$name);
                $find = false;

                // On recherche l'image dans les activity.activity
                $result = $this->em
                        ->getRepository('App:Activity')->createQueryBuilder('activity')
                        ->where('activity.activity LIKE :tofind')
                        ->setParameter('tofind', '%'.$tofind.'%')
                        ->getQuery()->getResult();
                if ($result) {
                    $find = true;
                }

                // Si pas trouvé on la cherche dans les activity.correctd
                if (!$find) {
                    $result = $this->em
                            ->getRepository('App:Activity')->createQueryBuilder('activity')
                            ->where('activity.corrected LIKE :tofind')
                            ->setParameter('tofind', '%'.$tofind.'%')
                            ->getQuery()->getResult();
                    if ($result) {
                        $find = true;
                    }
                }

                // Si pas trouvé on la cherche dans les answer.answer
                if (!$find) {
                    $result = $this->em
                            ->getRepository('App:Answer')->createQueryBuilder('answer')
                            ->where('answer.answer LIKE :tofind')
                            ->setParameter('tofind', '%'.$tofind.'%')
                            ->getQuery()->getResult();
                    if ($result) {
                        $find = true;
                    }
                }

                // Si pas trouvé on la cherche dans les answer.answercorrected
                if (!$find) {
                    $result = $this->em
                            ->getRepository('App:Answer')->createQueryBuilder('answer')
                            ->where('answer.answercorrected LIKE :tofind')
                            ->setParameter('tofind', '%'.$tofind.'%')
                            ->getQuery()->getResult();
                    if ($result) {
                        $find = true;
                    }
                }

                // Si pas trouvé on la cherche dans les document.description
                if (!$find) {
                    $result = $this->em
                            ->getRepository('App:Document')->createQueryBuilder('document')
                            ->where('document.description LIKE :tofind')
                            ->setParameter('tofind', '%'.$tofind.'%')
                            ->getQuery()->getResult();
                    if ($result) {
                        $find = true;
                    }
                }

                // Si pas trouvé on supprime
                if (!$find) {
                    $this->writeln($name);
                    $url = $directory.'/'.$name;
                    if ($fs->exists($url)) {
                        $fs->remove($url);
                    }
                }
            }
        }

        $this->writeln('');

        return 1;
    }

    private function purgeDocuemnt($entityname)
    {
        $directory = $this->container->get('kernel')->getProjectDir().'/uploads/document/'.$entityname;
        $this->writeln($directory);

        $files = [];
        $fs = new Filesystem();

        if ($fs->exists($directory)) {
            $finder = new Finder();
            $finder->in($directory)->directories()->exclude('thumb')->exclude('thumbmini');

            foreach (iterator_to_array($finder) as $file) {
                $name = $file->getRelativePathname();
                switch ($entityname) {
                    case 'activity':           $entity = $this->em->getRepository('App:Activity')->find($name); break;
                    case 'corrected':          $entity = $this->em->getRepository('App:Activity')->find($name); break;
                    case 'answer':             $entity = $this->em->getRepository('App:Answer')->find($name); break;
                    case 'answercorrected':    $entity = $this->em->getRepository('App:Answer')->find($name); break;
                }

                if (!$entity) {
                    $url = $directory.'/'.$name;
                    if ($fs->exists($url)) {
                        $this->writeln($name);
                        $fs->remove($url);
                    }
                } else {
                    $finder2 = new Finder();
                    $finder2->in($directory.'/'.$name)->files()->exclude('thumb')->exclude('thumbmini');
                    foreach (iterator_to_array($finder2) as $file2) {
                        $namefile = $file2->getRelativePathname();
                        $entity = $this->em->getRepository('App:Document')->findOneBy(['entity' => $entityname, 'filename' => $namefile]);
                        if (!$entity) {
                            $url = $directory.'/'.$name.'/'.$namefile;
                            $fs->remove($url);

                            $url = $directory.'/'.$name.'/thumb/'.$namefile;
                            $fs->remove($url);

                            $url = $directory.'/'.$name.'/thumbmini/'.$namefile;
                            $fs->remove($url);

                            $this->writeln($namefile);
                        }
                    }
                }
            }
        }
    }

    private function writelnred($string)
    {
        $this->output->writeln('<fg=red>'.$string.'</>');
        $this->filesystem->appendToFile($this->rootlog.'cron.log', $string."\n");
        if ($this->byexec) {
            $this->filesystem->appendToFile($this->rootlog.'exec.log', $string."\n");
        }
    }

    private function writeln($string)
    {
        $this->output->writeln($string);
        $this->filesystem->appendToFile($this->rootlog.'cron.log', $string."\n");
        if ($this->byexec) {
            $this->filesystem->appendToFile($this->rootlog.'exec.log', $string."\n");
        }
    }
}
