<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Answer
 *
 * @ORM\Table(name="answer")
 * @ORM\Entity(repositoryClass="App\Repository\AnswerRepository")
 */
class Answer
{
    /**
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\Column(name="status", type="integer")
     *
     */
    private $status;

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="answers")
     */
    private $user;

    /**
     * @ORM\Column(type="text", nullable=true)
     */
    private $answer;

    /**
     * @ORM\OneToMany(targetEntity="Document", mappedBy="answer", cascade={"persist"}, orphanRemoval=true)
     */
    private $answerdocuments;

    /**
     * @ORM\Column(type="text", nullable=true)
     */
    private $answercorrected;

    /**
     * @ORM\OneToMany(targetEntity="Document", mappedBy="answercorrected", cascade={"persist"}, orphanRemoval=true)
     */
    private $answercorrecteddocuments;

    /**
     * @ORM\OneToMany(targetEntity="Message", mappedBy="answer", cascade={"persist"}, orphanRemoval=true)
     */
    private $messages;

    /**
     * @ORM\ManyToOne(targetEntity="Activity", inversedBy="answers")
     */
    private $activity;
   
    public function getDisplayname()
    {
        return $this->user->getDisplayname();
    }

    public function __construct()
    {
        $this->answerdocuments = new ArrayCollection();
        $this->answercorrecteddocuments = new ArrayCollection();
        $this->messages = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getStatus(): ?int
    {
        return $this->status;
    }

    public function setStatus(int $status): self
    {
        $this->status = $status;

        return $this;
    }

    public function getAnswer(): ?string
    {
        return $this->answer;
    }

    public function setAnswer(?string $answer): self
    {
        $this->answer = $answer;

        return $this;
    }

    public function getAnswercorrected(): ?string
    {
        return $this->answercorrected;
    }

    public function setAnswercorrected(?string $answercorrected): self
    {
        $this->answercorrected = $answercorrected;

        return $this;
    }

    public function getUser(): ?User
    {
        return $this->user;
    }

    public function setUser(?User $user): self
    {
        $this->user = $user;

        return $this;
    }

    /**
     * @return Collection|Document[]
     */
    public function getAnswerdocuments(): Collection
    {
        return $this->answerdocuments;
    }

    public function addAnswerdocument(Document $answerdocument): self
    {
        if (!$this->answerdocuments->contains($answerdocument)) {
            $this->answerdocuments[] = $answerdocument;
            $answerdocument->setAnswer($this);
        }

        return $this;
    }

    public function removeAnswerdocument(Document $answerdocument): self
    {
        if ($this->answerdocuments->contains($answerdocument)) {
            $this->answerdocuments->removeElement($answerdocument);
            // set the owning side to null (unless already changed)
            if ($answerdocument->getAnswer() === $this) {
                $answerdocument->setAnswer(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|Document[]
     */
    public function getAnswercorrecteddocuments(): Collection
    {
        return $this->answercorrecteddocuments;
    }

    public function addAnswercorrecteddocument(Document $answercorrecteddocument): self
    {
        if (!$this->answercorrecteddocuments->contains($answercorrecteddocument)) {
            $this->answercorrecteddocuments[] = $answercorrecteddocument;
            $answercorrecteddocument->setAnswercorrected($this);
        }

        return $this;
    }

    public function removeAnswercorrecteddocument(Document $answercorrecteddocument): self
    {
        if ($this->answercorrecteddocuments->contains($answercorrecteddocument)) {
            $this->answercorrecteddocuments->removeElement($answercorrecteddocument);
            // set the owning side to null (unless already changed)
            if ($answercorrecteddocument->getAnswercorrected() === $this) {
                $answercorrecteddocument->setAnswercorrected(null);
            }
        }

        return $this;
    }

    public function getActivity(): ?Activity
    {
        return $this->activity;
    }

    public function setActivity(?Activity $activity): self
    {
        $this->activity = $activity;

        return $this;
    }

    /**
     * @return Collection|Message[]
     */
    public function getMessages(): Collection
    {
        return $this->messages;
    }

    public function addMessage(Message $message): self
    {
        if (!$this->messages->contains($message)) {
            $this->messages[] = $message;
            $message->setAnswer($this);
        }

        return $this;
    }

    public function removeMessage(Message $message): self
    {
        if ($this->messages->contains($message)) {
            $this->messages->removeElement($message);
            // set the owning side to null (unless already changed)
            if ($message->getAnswer() === $this) {
                $message->setAnswer(null);
            }
        }

        return $this;
    }


 
}