<?php

namespace Cadoles\CoreBundle\Service;

use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\Session\Session;

class colorService
{
    protected $color;   
    protected $container;

    public function __construct($container)
    {
        $this->container = $container;
    }

    public function setColor() {
        $session = $this->container->get('session');

        $colormain      =$session->get('colormain');
        $colorlight     =$this->adjustBrightness($colormain,+50);
        $colordark      =$this->adjustBrightness($colormain,-50);
        $colormainrgb   =$this->hexToRgb($colormain);
        $colorlightrgb  =$this->hexToRgb($colorlight);
        $colordarkrgb   =$this->hexToRgb($colordark);        

        $fontcolorhover =$session->get('fontcolorhover');
        $colorbody      =$session->get('colorbody');

        $tbcolor=array(
            "main"                  =>$colormain,
            "light"                 =>$this->adjustBrightness($colormain,+50),
            "dark"                  =>$this->adjustBrightness($colormain,-50),
            "mainrgb"               =>$this->hexToRgb($colormain),
            "lightrgb"              =>$this->hexToRgb($colorlight),
            "darkrgb"               =>$this->hexToRgb($colordark),

            "fontcolorhover"        =>$fontcolorhover,
            "fontcolorhoverlight"   =>$this->adjustBrightness($fontcolorhover,+50),
            "fontcolorhoverdark"    =>$this->adjustBrightness($fontcolorhover,-50),

            "colorbody"             =>$colorbody,
        );
        
        $session->set('color', $tbcolor);
    }

    public function adjustBrightness($hex, $steps) {
        // Steps should be between -255 and 255. Negative = darker, positive = lighter
        $steps = max(-255, min(255, $steps));

        // Normalize into a six character long hex string
        $hex = str_replace('#', '', $hex);
        if (strlen($hex) == 3) {
            $hex = str_repeat(substr($hex,0,1), 2).str_repeat(substr($hex,1,1), 2).str_repeat(substr($hex,2,1), 2);
        }

        // Split into three parts: R, G and B
        $color_parts = str_split($hex, 2);
        $return = '';

        foreach ($color_parts as $color) {
            $color   = hexdec($color); // Convert to decimal
            $color   = max(0,min(255,$color + $steps)); // Adjust color
            $return .= str_pad(dechex($color), 2, '0', STR_PAD_LEFT); // Make two char hex code
        }

        return $return;
    }

    public function hexToRgb($hex) {
       $hex      = str_replace('#', '', $hex);
       $length   = strlen($hex);
       $rgb['r'] = hexdec($length == 6 ? substr($hex, 0, 2) : ($length == 3 ? str_repeat(substr($hex, 0, 1), 2) : 0));
       $rgb['g'] = hexdec($length == 6 ? substr($hex, 2, 2) : ($length == 3 ? str_repeat(substr($hex, 1, 1), 2) : 0));
       $rgb['b'] = hexdec($length == 6 ? substr($hex, 4, 2) : ($length == 3 ? str_repeat(substr($hex, 2, 1), 2) : 0));

       return $rgb;
   }
}
