<?php
namespace App\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Finder\Finder;
use Symfony\Component\Filesystem\Filesystem;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Doctrine\ORM\EntityManagerInterface;

class PurgeFileCommand extends Command
{
    private $container;
    private $em;
    private $output;
    private $filesystem;
    private $rootlog;


    public function __construct(ContainerInterface $container, EntityManagerInterface $em)
    {
        parent::__construct();
        $this->container = $container;
        $this->em = $em;
    }

    protected function configure()
    {
        $this
            ->setName('app:PurgeFile')
            ->setDescription('Purge Files')
            ->setHelp('This command Purge the obsolete Files')
            ->addArgument('cronid', InputArgument::OPTIONAL, 'ID Cron Job') 
            ->addArgument('lastchance', InputArgument::OPTIONAL, 'Lastchance to run the cron')
        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->output       = $output;
        $this->filesystem   = new Filesystem();
        $this->rootlog      = $this->container->get('kernel')->getProjectDir()."/var/log/";
        $alias              = $this->container->getParameter('alias');

        $this->writelnred('');
        $this->writelnred('== app:PurgeFile');        
        $this->writelnred('==========================================================================================================');

        $now=new \DateTime('now');

        // /uploads/file
        $this->writelnred('');
        $this->writelnred('== Directory = File');        

        $directory=$this->container->get('kernel')->getProjectDir()."/uploads/file";
        $files=[];
        $fs = new Filesystem();

        if($fs->exists($directory)) {
            $finder = new Finder();
            $finder->depth('== 0')->in($directory)->directories();

            foreach (iterator_to_array($finder) as $file) {
                $name   = $file->getRelativePathname();
                $type   = explode("-",$name)[0];
                $id     = explode("-",$name)[1];

                switch($type) {
                    case "widget":
                        $entity=$this->em->getRepository("App\Entity\Pagewidget")->find($id);
                        if(!$entity) {
                            $this->writeln($name);
                            $url=$directory."/".$name;
                            if($fs->exists($url)) {
                                $fs->remove($url);
                            }                            
                        }
                    break;

                    case "projecttask":
                        $entity=$this->em->getRepository("App\Entity\Projecttask")->find($id);
                        if(!$entity) {
                            $this->writeln($name);
                            $url=$directory."/".$name;
                            if($fs->exists($url)) {
                                $fs->remove($url);
                            }                            
                        }
                    break;

                    case "calendarevent":
                        $entity=$this->em->getRepository("App\Entity\Calendarevent")->find($id);
                        if(!$entity) {
                            $this->writeln($name);
                            $url=$directory."/".$name;
                            if($fs->exists($url)) {
                                $fs->remove($url);
                            }                            
                        }
                    break;
                }
            }
        }

        // /web/uploads/avatar
        $this->writelnred('');
        $this->writelnred('== Directory = Avatar');

        $directory=$this->container->get('kernel')->getProjectDir()."/public/uploads/avatar";
        $files=[];
        $fs = new Filesystem();

        if($fs->exists($directory)) {
            $finder = new Finder();
            $finder->in($directory)->files();

            foreach (iterator_to_array($finder) as $file) {
                $name   = $file->getRelativePathname();
                if($name!="admin.jpg"&&$name!="noavatar.png"&&$name!="system.jpg") {
                    $entity=$this->em->getRepository("App\Entity\User")->findBy(["avatar"=>$name]);
                    if(!$entity) { 
                        $this->writeln($name);
                        $url=$directory."/".$name;
                        if($fs->exists($url)) {
                            $fs->remove($url);
                        }                          
                    }
                }
            }
        }

        $fs = new Filesystem();
        $users=$this->em->getRepository("App\Entity\User")->findAll();
        foreach($users as $user) {
            if(!$fs->exists($directory."/".$user->getAvatar())) {
                $this->writeln($user->getUsername());
                $user->setAvatar("noavatar.png");
                $this->em->persist($user);
                $this->em->flush();                
            }
        }

        // /web/uploads/header
        $this->writelnred('');
        $this->writelnred('== Directory = Header');

        $directory=$this->container->get('kernel')->getProjectDir()."/public/uploads/header";
        $files=[];
        $fs = new Filesystem();

        if($fs->exists($directory)) {
            $finder = new Finder();
            $finder->in($directory)->files();

            foreach (iterator_to_array($finder) as $file) {
                $name   = $file->getRelativePathname();
                if($name!="header.png") {
                    $entity=$this->em->getRepository("App\Entity\Config")->findBy(["id"=>"header","value"=>"uploads/header/".$name]);
                    if(!$entity) {
                        $this->writeln($name);
                        $url=$directory."/".$name;
                        if($fs->exists($url)) {
                            $fs->remove($url);
                        }                          
                    }
                }
            }
        }

        // /web/uploads/logo
        $this->writelnred('');
        $this->writelnred('== Directory = Logo');

        $directory=$this->container->get('kernel')->getProjectDir()."/public/uploads/logo";
        $files=[];
        $fs = new Filesystem();

        if($fs->exists($directory)) {
            $finder = new Finder();
            $finder->in($directory)->files();

            foreach (iterator_to_array($finder) as $file) {
                $name   = $file->getRelativePathname();
                if($name!="logo.png") {
                    $entity=$this->em->getRepository("App\Entity\Config")->findBy(["id"=>"logo","value"=>"uploads/logo/".$name]);
                    if(!$entity) {
                        $this->writeln($name);
                        $url=$directory."/".$name;
                        if($fs->exists($url)) {
                            $fs->remove($url);
                        }                          
                    }
                }
            }
        }

        // /web/uploads/niveau01
        $this->writelnred('');
        $this->writelnred('== Directory = Niveau01');

        $directory=$this->container->get('kernel')->getProjectDir()."/public/uploads/niveau01";
        $files=[];
        $fs = new Filesystem();

        if($fs->exists($directory)) {
            $finder = new Finder();
            $finder->in($directory)->files();

            foreach (iterator_to_array($finder) as $file) {
                $name   = $file->getRelativePathname();
                if($name!="logo.png") {
                    $logo=$this->em->getRepository("App\Entity\Niveau01")->findBy(["logo"=>"uploads/niveau01/".$name]);
                    $header=$this->em->getRepository("App\Entity\Niveau01")->findBy(["header"=>"uploads/niveau01/".$name]);
                    if(!$logo&&!$header) {
                        $this->writeln($name);
                        $url=$directory."/".$name;
                        if($fs->exists($url)) {
                            $fs->remove($url);
                        }                          
                    }
                }
            }
        }

        // /web/uploads/slide
        $this->writelnred('');
        $this->writelnred('== Directory = Slide');

        $directory=$this->container->get('kernel')->getProjectDir()."/public/uploads/slide";
        $files=[];
        $fs = new Filesystem();

        if($fs->exists($directory)) {
            $finder = new Finder();
            $finder->in($directory)->files();

            foreach (iterator_to_array($finder) as $file) {
                $name   = $file->getRelativePathname();
                $entity=$this->em->getRepository("App\Entity\Slide")->findBy(["image"=>"uploads/slide/".$name]);
                if(!$entity) {
                    $this->writeln($name);
                    $url=$directory."/".$name;
                    if($fs->exists($url)) {
                        $fs->remove($url);
                    }                          
                }
            }
        }

        // /web/uploads/icon
        $this->writelnred('');
        $this->writelnred('== Directory = Icon');

        $directory=$this->container->get('kernel')->getProjectDir()."/public/uploads/icon";
        $files=[];
        $fs = new Filesystem();

        if($fs->exists($directory)) {
            $finder = new Finder();
            $finder->in($directory)->files();

            foreach (iterator_to_array($finder) as $file) {
                $name   = $file->getRelativePathname();
                if(!stripos($name,"icon_")) {
                    $entity=$this->em->getRepository("App\Entity\Icon")->findBy(["label"=>"uploads/icon/".$name]);
                    if(!$entity) {
                        $this->writeln($name);
                        $url=$directory."/".$name;
                        if($fs->exists($url)) {
                            $fs->remove($url);
                        }                          
                    }
                }
            }
        }

        $directory=$this->container->get('kernel')->getProjectDir()."/public";
        $icons=$this->em->getRepository("App\Entity\Icon")->findAll();
        foreach($icons as $icon) {
            if(!$fs->exists($directory."/".$icon->getLabel())) {
                $this->writeln($directory."/".$icon->getLabel());
                $this->em->remove($icon);
                $this->em->flush();
            }
        }

        // /web/uploads/blogarticle
        $this->writelnred('');
        $this->writelnred('== Directory = Blog Article');

        $directory=$this->container->get('kernel')->getProjectDir()."/public/uploads/blogarticle";
        $files=[];
        $fs = new Filesystem();

        if($fs->exists($directory)) {
            $finder = new Finder();
            $finder->in($directory)->files();

            foreach (iterator_to_array($finder) as $file) {
                $name   = $file->getRelativePathname();
                if(strpos($name,"thumb-")===false) {
                    $entity=$this->em->getRepository("App\Entity\Blogarticle")->findBy(["image"=>"uploads/blogarticle/".$name]);
                    if(!$entity) {
                        $this->writeln($name);
                        
                        // Suppression du fichier
                        $url=$directory."/".$name;
                        if($fs->exists($url)) {
                            $fs->remove($url);
                        } 
                        
                        // Suppression du thumb fichier
                        $url=$directory."/thumb-".$name;
                        if($fs->exists($url)) {
                            $fs->remove($url);
                        } 
                    }
                }
            }
        }

        // /web/uploads/ckeditor
        $this->writelnred('');
        $this->writelnred('== Directory = Ckeditor');
        $directory=$this->container->get('kernel')->getProjectDir()."/public/uploads/ckeditor";
        $files=[];
        $fs = new Filesystem();

        if($fs->exists($directory)) {
            $finder = new Finder();
            $finder->in($directory)->files();

            foreach (iterator_to_array($finder) as $file) {
                $name   = $file->getRelativePathname();
                $tofind = "/".$alias."uploads/ckeditor/".$name;
                $find=false;
                
                // On recherche l'image dans les pages
                $result = $this->em
                        ->getRepository("App\Entity\Page")->createQueryBuilder('page')
                        ->where('page.html LIKE :tofind')
                        ->setParameter('tofind', '%'.$tofind.'%')
                        ->getQuery()->getResult();                
                if($result) $find=true;

                // Si pas trouvé on la cherche dans les widgets
                if(!$find) {
                    $result = $this->em
                            ->getRepository("App\Entity\Pagewidget")->createQueryBuilder('pagewidget')
                            ->where('pagewidget.parameter LIKE :tofind')
                            ->setParameter('tofind', '%'.$tofind.'%')
                            ->getQuery()->getResult();                
                    if($result) $find=true;
                }

                // Si pas trouvé on la cherche dans les blogarticle
                if(!$find) {
                    $result = $this->em
                            ->getRepository("App\Entity\Blogarticle")->createQueryBuilder('blogarticle')
                            ->where('blogarticle.description LIKE :tofind')
                            ->setParameter('tofind', '%'.$tofind.'%')
                            ->getQuery()->getResult();                
                    if($result) $find=true;
                }

                // Si pas trouvé on la cherche dans les blogcomment
                if(!$find) {
                    $result = $this->em
                            ->getRepository("App\Entity\Blogcomment")->createQueryBuilder('blogcomment')
                            ->where('blogcomment.description LIKE :tofind')
                            ->setParameter('tofind', '%'.$tofind.'%')
                            ->getQuery()->getResult();                
                    if($result) $find=true;
                }

                // Si pas trouvé on la cherche dans les projecttask
                if(!$find) {
                    $result = $this->em
                            ->getRepository("App\Entity\Projecttask")->createQueryBuilder('projecttask')
                            ->where('projecttask.description LIKE :tofind')
                            ->setParameter('tofind', '%'.$tofind.'%')
                            ->getQuery()->getResult();                
                    if($result) $find=true;
                }

                // Si pas trouvé on la cherche dans les projectcomment
                if(!$find) {
                    $result = $this->em
                            ->getRepository("App\Entity\Projectcomment")->createQueryBuilder('projectcomment')
                            ->where('projectcomment.description LIKE :tofind')
                            ->setParameter('tofind', '%'.$tofind.'%')
                            ->getQuery()->getResult();                
                    if($result) $find=true;
                }

                // Si pas trouvé on la cherche dans les blogcomment
                if(!$find) {
                    $result = $this->em
                            ->getRepository("App\Entity\Blogcomment")->createQueryBuilder('blogcomment')
                            ->where('blogcomment.description LIKE :tofind')
                            ->setParameter('tofind', '%'.$tofind.'%')
                            ->getQuery()->getResult();                
                    if($result) $find=true;
                }

                // Si pas trouvé on la cherche dans les alert
                if(!$find) {
                    $result = $this->em
                            ->getRepository("App\Entity\Alert")->createQueryBuilder('alert')
                            ->where('alert.content LIKE :tofind')
                            ->setParameter('tofind', '%'.$tofind.'%')
                            ->getQuery()->getResult();                
                    if($result) $find=true;
                }

                // Si pas trouvé on supprime
                if(!$find) {
                    $this->writeln($name);
                    $url=$directory."/".$name;
                    if($fs->exists($url)) {
                        $fs->remove($url);
                    }                       
                }
            }
        }

        // /web/uploads/ckeditor
        $this->writelnred('');
        $this->writelnred('== Directory = Flux');
        $directory=$this->container->get('kernel')->getProjectDir()."/public/uploads/flux";
        $fs = new Filesystem();
        $fs->remove($directory);
        
        
        
        $this->writeln('');
        return Command::SUCCESS;
    }

    private function writelnred($string) { 
        $this->output->writeln('<fg=red>'.$string.'</>');
        $this->filesystem->appendToFile($this->rootlog.'cron.log', $string."\n");
    }
    private function writeln($string) { 
        $this->output->writeln($string);
        $this->filesystem->appendToFile($this->rootlog.'cron.log', $string."\n");
    }     
}
