<?php
namespace Cadoles\CoreBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;

use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Entity
 * @ORM\Table(name="groupe")
 * @ORM\HasLifecycleCallbacks()
 * @ORM\Entity(repositoryClass="Cadoles\CoreBundle\Repository\GroupRepository")
 * 
 * @UniqueEntity(fields="label", message="Un group existe déjà avec ce label")
 */
class Group
{
    /**
     * @ORM\Column(type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=250, unique=true)
     */
    private $label;

    /**
    * @var string
    *
    * @ORM\Column(name="description", type="text", nullable=true)
    */
    private $description;

    /**
     * @var string
     *
     * @ORM\Column(name="color", type="string", length=24,  nullable=true)
     */
    private $color;

    /**
     * @ORM\Column(type="string", length=250, nullable=true)
     */
    private $email;

    /**
     * @ORM\Column(type="boolean", options={"default" : false})
     */
    private $fgopen;
    
    /**
     * @ORM\Column(type="boolean", options={"default" : true})
     */
    private $fgcanshare;    

    /**
     * @ORM\Column(type="boolean", options={"default" : false})
     */
    private $fgcancreatepage;  

    /**
     * @ORM\Column(type="boolean", options={"default" : false})
     */
    private $fgcancreateblog;  

    /**
     * @ORM\Column(type="boolean", options={"default" : false})
     */
    private $fgcancreatecalendar;  

    /**
     * @ORM\Column(type="boolean", options={"default" : false})
     */
    private $fgcancreateproject;  

    /**
     * @ORM\Column(type="boolean", options={"default" : false})
     */
    private $fgall;

    /**
     * @ORM\Column(type="boolean", options={"default" : false})
     */
    private $fgtemplate;    

    /**
     * @ORM\Column(type="text", nullable=true)
     */
    private $ldapfilter;

    /**
     * @ORM\Column(type="text", nullable=true)
     */
    private $attributes;

    /**
     * @ORM\Column(type="string", length=250, nullable=true)
     */
    private $idonlyoffice;

    /**
     * @ORM\Column(name="invitations", type="array", nullable=true)
     */
    private $invitations;

    /**
     * @ORM\ManyToOne(targetEntity="Cadoles\PortalBundle\Entity\Icon", inversedBy="groups")
     * @ORM\JoinColumn(nullable=true, onDelete="SET NULL")
     */
    private $icon;

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="ownergroups")
     * @ORM\JoinColumn(nullable=true, onDelete="SET NULL")
     */
    private $owner;

    /**
     * @ORM\ManyToOne(targetEntity="Cadoles\PortalBundle\Entity\Page", inversedBy="templategroups")
     */
    private $pagetemplate;

    /**
     * @var ArrayCollection $users
     * @var UserGroup
     *
     * @ORM\OneToMany(targetEntity="UserGroup", mappedBy="group", cascade={"persist"}, orphanRemoval=true)
     */
    private $users;

    /**
    * @ORM\ManyToMany(targetEntity="Cadoles\PortalBundle\Entity\Item", mappedBy="groups")
    */    
    protected $items;

    /**
    * @ORM\ManyToMany(targetEntity="Cadoles\PortalBundle\Entity\Alert", mappedBy="groups")
    */    
    protected $alerts;

    /**
    * @ORM\ManyToMany(targetEntity="Cadoles\PortalBundle\Entity\Page", mappedBy="groups")
    */    
    protected $pages;

    /**
    * @ORM\ManyToMany(targetEntity="Cadoles\PortalBundle\Entity\Flux", mappedBy="groups")
    */    
    protected $fluxs;

    /**
    * @ORM\ManyToMany(targetEntity="Cadoles\PortalBundle\Entity\Notice", mappedBy="groups")
    */    
    protected $notices;    

    /**
    * @ORM\ManyToMany(targetEntity="Cadoles\PortalBundle\Entity\Calendar", mappedBy="groups")
    */    
    protected $calendars;  

    /**
    * @ORM\ManyToMany(targetEntity="Cadoles\PortalBundle\Entity\Calendarevent", mappedBy="groups")
    */    
    protected $calendarevents;  

    /**
    * @ORM\ManyToMany(targetEntity="Cadoles\PortalBundle\Entity\Blog", mappedBy="groups")
    */    
    protected $blogs;  

    /**
    * @ORM\ManyToMany(targetEntity="Cadoles\PortalBundle\Entity\Project", mappedBy="groups")
    */    
    protected $projects;  
    
    /**
     * @var ArrayCollection $message
     * @var Message
     *
     * @ORM\OneToMany(targetEntity="Cadoles\WebsocketBundle\Entity\Message", mappedBy="group", cascade={"persist"}, orphanRemoval=true)
     */
    protected $messages;  

    /**
     * @ORM\OneToMany(targetEntity="Statistic", mappedBy="group", cascade={"persist"}, orphanRemoval=true)
     */
    private $statistics;

    // Champs temporaire
    protected $nosynconly;
    public function getNosynconly()
    {
        return $this->nosynconly;
    }
    public function setNosynconly($nosynconly)
    {
        $this->nosynconly = $nosynconly;
        return $this;
    }



    // ATTENTION NE SURTOUT PAS REGEN TOTALEMENT LES SETTER
    // Methode custom sur les Addxxx et Removexxx

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->users = new \Doctrine\Common\Collections\ArrayCollection();
        $this->items = new \Doctrine\Common\Collections\ArrayCollection();
        $this->alerts = new \Doctrine\Common\Collections\ArrayCollection();
        $this->pages = new \Doctrine\Common\Collections\ArrayCollection();
        $this->fluxs = new \Doctrine\Common\Collections\ArrayCollection();
        $this->notices = new \Doctrine\Common\Collections\ArrayCollection();
        $this->calendars = new \Doctrine\Common\Collections\ArrayCollection();
        $this->blogs = new \Doctrine\Common\Collections\ArrayCollection();
        $this->projects = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set label
     *
     * @param string $label
     *
     * @return Group
     */
    public function setLabel($label)
    {
        $this->label = $label;

        return $this;
    }

    /**
     * Get label
     *
     * @return string
     */
    public function getLabel()
    {
        return $this->label;
    }

    /**
     * Set fgopen
     *
     * @param boolean $fgopen
     *
     * @return Group
     */
    public function setFgopen($fgopen)
    {
        $this->fgopen = $fgopen;

        return $this;
    }

    /**
     * Get fgopen
     *
     * @return boolean
     */
    public function getFgopen()
    {
        return $this->fgopen;
    }

    /**
     * Set fgcanshare
     *
     * @param boolean $fgcanshare
     *
     * @return Group
     */
    public function setFgcanshare($fgcanshare)
    {
        $this->fgcanshare = $fgcanshare;

        return $this;
    }

    /**
     * Get fgcanshare
     *
     * @return boolean
     */
    public function getFgcanshare()
    {
        return $this->fgcanshare;
    }

    /**
     * Set fgcancreatepage
     *
     * @param boolean $fgcancreatepage
     *
     * @return Group
     */
    public function setFgcancreatepage($fgcancreatepage)
    {
        $this->fgcancreatepage = $fgcancreatepage;

        return $this;
    }

    /**
     * Get fgcancreatepage
     *
     * @return boolean
     */
    public function getFgcancreatepage()
    {
        return $this->fgcancreatepage;
    }

    /**
     * Set fgcancreateblog
     *
     * @param boolean $fgcancreateblog
     *
     * @return Group
     */
    public function setFgcancreateblog($fgcancreateblog)
    {
        $this->fgcancreateblog = $fgcancreateblog;

        return $this;
    }

    /**
     * Get fgcancreateblog
     *
     * @return boolean
     */
    public function getFgcancreateblog()
    {
        return $this->fgcancreateblog;
    }

    /**
     * Set fgcancreatecalendar
     *
     * @param boolean $fgcancreatecalendar
     *
     * @return Group
     */
    public function setFgcancreatecalendar($fgcancreatecalendar)
    {
        $this->fgcancreatecalendar = $fgcancreatecalendar;

        return $this;
    }

    /**
     * Get fgcancreatecalendar
     *
     * @return boolean
     */
    public function getFgcancreatecalendar()
    {
        return $this->fgcancreatecalendar;
    }

    /**
     * Set fgall
     *
     * @param boolean $fgall
     *
     * @return Group
     */
    public function setFgall($fgall)
    {
        $this->fgall = $fgall;

        return $this;
    }

    /**
     * Get fgall
     *
     * @return boolean
     */
    public function getFgall()
    {
        return $this->fgall;
    }

    /**
     * Set fgtemplate
     *
     * @param boolean $fgtemplate
     *
     * @return Group
     */
    public function setFgtemplate($fgtemplate)
    {
        $this->fgtemplate = $fgtemplate;

        return $this;
    }

    /**
     * Get fgtemplate
     *
     * @return boolean
     */
    public function getFgtemplate()
    {
        return $this->fgtemplate;
    }

    /**
     * Set ldapfilter
     *
     * @param string $ldapfilter
     *
     * @return Group
     */
    public function setLdapfilter($ldapfilter)
    {
        $this->ldapfilter = $ldapfilter;

        return $this;
    }

    /**
     * Get ldapfilter
     *
     * @return string
     */
    public function getLdapfilter()
    {
        return $this->ldapfilter;
    }

    /**
     * Set attributes
     *
     * @param string $attributes
     *
     * @return Group
     */
    public function setAttributes($attributes)
    {
        $this->attributes = $attributes;

        return $this;
    }

    /**
     * Get attributes
     *
     * @return string
     */
    public function getAttributes()
    {
        return $this->attributes;
    }

    /**
     * Set idonlyoffice
     *
     * @param string $idonlyoffice
     *
     * @return Group
     */
    public function setIdonlyoffice($idonlyoffice)
    {
        $this->idonlyoffice = $idonlyoffice;

        return $this;
    }

    /**
     * Get idonlyoffice
     *
     * @return string
     */
    public function getIdonlyoffice()
    {
        return $this->idonlyoffice;
    }

    /**
     * Add user
     *
     * @param \Cadoles\CoreBundle\Entity\UserGroup $user
     *
     * @return Group
     */
    public function addUser(\Cadoles\CoreBundle\Entity\UserGroup $user)
    {
        $this->users[] = $user;

        return $this;
    }

    /**
     * Remove user
     *
     * @param \Cadoles\CoreBundle\Entity\UserGroup $user
     */
    public function removeUser(\Cadoles\CoreBundle\Entity\UserGroup $user)
    {
        $this->users->removeElement($user);
    }

    /**
     * Get users
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getUsers()
    {
        return $this->users;
    }

    /**
     * Add item
     *
     * @param \Cadoles\PortalBundle\Entity\Item $item
     *
     * @return Group
     */
    public function addItem(\Cadoles\PortalBundle\Entity\Item $item)
    {
        $item->addGroup($this);
        $this->items[] = $item;

        return $this;
    }

    /**
     * Remove item
     *
     * @param \Cadoles\PortalBundle\Entity\Item $item
     */
    public function removeItem(\Cadoles\PortalBundle\Entity\Item $item)
    {
        $item->removeGroup($this);
        $this->items->removeElement($item);
    }

    /**
     * Get items
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getItems()
    {
        return $this->items;
    }

    /**
     * Add alert
     *
     * @param \Cadoles\PortalBundle\Entity\Alert $alert
     *
     * @return Group
     */
    public function addAlert(\Cadoles\PortalBundle\Entity\Alert $alert)
    {
        $alert->addGroup($this);
        $this->alerts[] = $alert;

        return $this;
    }

    /**
     * Remove alert
     *
     * @param \Cadoles\PortalBundle\Entity\Alert $alert
     */
    public function removeAlert(\Cadoles\PortalBundle\Entity\Alert $alert)
    {
        $alert->removeGroup($this);
        $this->alerts->removeElement($alert);
    }

    /**
     * Get alerts
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getAlerts()
    {
        return $this->alerts;
    }

    /**
     * Add page
     *
     * @param \Cadoles\PortalBundle\Entity\Page $page
     *
     * @return Group
     */
    public function addPage(\Cadoles\PortalBundle\Entity\Page $page)
    {
        $page->addGroup($this);
        $this->pages[] = $page;

        return $this;
    }

    /**
     * Remove page
     *
     * @param \Cadoles\PortalBundle\Entity\Page $page
     */
    public function removePage(\Cadoles\PortalBundle\Entity\Page $page)
    {
        $page->removeGroup($this);
        $this->pages->removeElement($page);
    }

    /**
     * Get pages
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getPages()
    {
        return $this->pages;
    }

    /**
     * Add flux
     *
     * @param \Cadoles\PortalBundle\Entity\Flux $flux
     *
     * @return Group
     */
    public function addFlux(\Cadoles\PortalBundle\Entity\Flux $flux)
    {
        $flux->addGroup($this);
        $this->fluxs[] = $flux;

        return $this;
    }

    /**
     * Remove flux
     *
     * @param \Cadoles\PortalBundle\Entity\Flux $flux
     */
    public function removeFlux(\Cadoles\PortalBundle\Entity\Flux $flux)
    {
        $flux->removeGroup($this);
        $this->fluxs->removeElement($flux);
    }

    /**
     * Get fluxs
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getFluxs()
    {
        return $this->fluxs;
    }

    /**
     * Add notice
     *
     * @param \Cadoles\PortalBundle\Entity\Notice $notice
     *
     * @return Group
     */
    public function addNotice(\Cadoles\PortalBundle\Entity\Notice $notice)
    {
        $notice->addGroup($this);
        $this->notices[] = $notice;

        return $this;
    }

    /**
     * Remove notice
     *
     * @param \Cadoles\PortalBundle\Entity\Notice $notice
     */
    public function removeNotice(\Cadoles\PortalBundle\Entity\Notice $notice)
    {
        $notice->removeGroup($this);
        $this->notices->removeElement($notice);
    }

    /**
     * Get notices
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getNotices()
    {
        return $this->notices;
    }

    /**
     * Add calendar
     *
     * @param \Cadoles\PortalBundle\Entity\Calendar $calendar
     *
     * @return Group
     */
    public function addCalendar(\Cadoles\PortalBundle\Entity\Calendar $calendar)
    {
        $calendar->addGroup($this);
        $this->calendars[] = $calendar;

        return $this;
    }

    /**
     * Remove calendar
     *
     * @param \Cadoles\PortalBundle\Entity\Calendar $calendar
     */
    public function removeCalendar(\Cadoles\PortalBundle\Entity\Calendar $calendar)
    {
        $calendar->removeGroup($this);
        $this->calendars->removeElement($calendar);
    }

    /**
     * Get calendars
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getCalendars()
    {
        return $this->calendars;
    }

    /**
     * Add blog
     *
     * @param \Cadoles\PortalBundle\Entity\Blog $blog
     *
     * @return Group
     */
    public function addBlog(\Cadoles\PortalBundle\Entity\Blog $blog)
    {
        $blog->addGroup($this);
        $this->blogs[] = $blog;

        return $this;
    }

    /**
     * Remove blog
     *
     * @param \Cadoles\PortalBundle\Entity\Blog $blog
     */
    public function removeBlog(\Cadoles\PortalBundle\Entity\Blog $blog)
    {
        $blog->removeGroup($this);
        $this->blogs->removeElement($blog);
    }

    /**
     * Get blogs
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getBlogs()
    {
        return $this->blogs;
    }

    /**
     * Set description
     *
     * @param string $description
     *
     * @return Group
     */
    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }

    /**
     * Get description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Set icon
     *
     * @param \Cadoles\PortalBundle\Entity\Icon $icon
     *
     * @return Group
     */
    public function setIcon(\Cadoles\PortalBundle\Entity\Icon $icon = null)
    {
        $this->icon = $icon;

        return $this;
    }

    /**
     * Get icon
     *
     * @return \Cadoles\PortalBundle\Entity\Icon
     */
    public function getIcon()
    {
        return $this->icon;
    }

    /**
     * Set owner
     *
     * @param \Cadoles\CoreBundle\Entity\User $owner
     *
     * @return Group
     */
    public function setOwner(\Cadoles\CoreBundle\Entity\User $owner = null)
    {
        $this->owner = $owner;

        return $this;
    }

    /**
     * Get owner
     *
     * @return \Cadoles\CoreBundle\Entity\User
     */
    public function getOwner()
    {
        return $this->owner;
    }

    /**
     * Set color
     *
     * @param string $color
     *
     * @return Group
     */
    public function setColor($color)
    {
        $this->color = $color;

        return $this;
    }

    /**
     * Get color
     *
     * @return string
     */
    public function getColor()
    {
        return $this->color;
    }

    /**
     * Set pagetemplate
     *
     * @param \Cadoles\PortalBundle\Entity\Page $pagetemplate
     *
     * @return Group
     */
    public function setPagetemplate(\Cadoles\PortalBundle\Entity\Page $pagetemplate = null)
    {
        $this->pagetemplate = $pagetemplate;

        return $this;
    }

    /**
     * Get pagetemplate
     *
     * @return \Cadoles\PortalBundle\Entity\Page
     */
    public function getPagetemplate()
    {
        return $this->pagetemplate;
    }

    /**
     * Add message
     *
     * @param \Cadoles\WebsocketBundle\Entity\Message $message
     *
     * @return Group
     */
    public function addMessage(\Cadoles\WebsocketBundle\Entity\Message $message)
    {
        $this->messages[] = $message;

        return $this;
    }

    /**
     * Remove message
     *
     * @param \Cadoles\WebsocketBundle\Entity\Message $message
     */
    public function removeMessage(\Cadoles\WebsocketBundle\Entity\Message $message)
    {
        $this->messages->removeElement($message);
    }

    /**
     * Get messages
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getMessages()
    {
        return $this->messages;
    }

    /**
     * Add calendarevent
     *
     * @param \Cadoles\PortalBundle\Entity\Calendarevent $calendarevent
     *
     * @return Group
     */
    public function addCalendarevent(\Cadoles\PortalBundle\Entity\Calendarevent $calendarevent)
    {
        $this->calendarevents[] = $calendarevent;

        return $this;
    }

    /**
     * Remove calendarevent
     *
     * @param \Cadoles\PortalBundle\Entity\Calendarevent $calendarevent
     */
    public function removeCalendarevent(\Cadoles\PortalBundle\Entity\Calendarevent $calendarevent)
    {
        $this->calendarevents->removeElement($calendarevent);
    }

    /**
     * Get calendarevents
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getCalendarevents()
    {
        return $this->calendarevents;
    }

    /**
     * Add project
     *
     * @param \Cadoles\PortalBundle\Entity\Project $project
     *
     * @return Group
     */
    public function addProject(\Cadoles\PortalBundle\Entity\Project $project)
    {
        $project->addGroup($this);
        $this->projects[] = $project;

        return $this;
    }

    /**
     * Remove project
     *
     * @param \Cadoles\PortalBundle\Entity\Project $project
     */
    public function removeProject(\Cadoles\PortalBundle\Entity\Project $project)
    {
        $project->removeGroup($this);
        $this->projects->removeElement($project);
    }

    /**
     * Get projects
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getProjects()
    {
        return $this->projects;
    }


    /**
     * Set fgcancreateproject
     *
     * @param boolean $fgcancreateproject
     *
     * @return Group
     */
    public function setFgcancreateproject($fgcancreateproject)
    {
        $this->fgcancreateproject = $fgcancreateproject;

        return $this;
    }

    /**
     * Get fgcancreateproject
     *
     * @return boolean
     */
    public function getFgcancreateproject()
    {
        return $this->fgcancreateproject;
    }

    /**
     * Add statistic
     *
     * @param \Cadoles\CoreBundle\Entity\Statistic $statistic
     *
     * @return Group
     */
    public function addStatistic(\Cadoles\CoreBundle\Entity\Statistic $statistic)
    {
        $this->statistics[] = $statistic;

        return $this;
    }

    /**
     * Remove statistic
     *
     * @param \Cadoles\CoreBundle\Entity\Statistic $statistic
     */
    public function removeStatistic(\Cadoles\CoreBundle\Entity\Statistic $statistic)
    {
        $this->statistics->removeElement($statistic);
    }

    /**
     * Get statistics
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getStatistics()
    {
        return $this->statistics;
    }

    /**
     * Set email.
     *
     * @param string|null $email
     *
     * @return Group
     */
    public function setEmail($email = null)
    {
        $this->email = $email;

        return $this;
    }

    /**
     * Get email.
     *
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * Set invitations
     *
     * @param array $invitations
     *
     * @return Group
     */
    public function setInvitations($invitations)
    {
        $this->invitations = $invitations;

        return $this;
    }

    /**
     * Get invitations
     *
     * @return array
     */
    public function getInvitations()
    {
        return $this->invitations;
    }
}
