<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Doctrine\Persistence\ManagerRegistry;

class StatisticController extends AbstractController
{
    public function list(Request $request, ManagerRegistry $em)
    {
        $totcptvisite=$em->getRepository("App\Entity\Statistic")->findOneBy(["keyvalue"=>"totcptvisite"]);
        $totcptvisitegroup=$em->getRepository("App\Entity\Statistic")->findOneBy(["keyvalue"=>"totcptvisitegroup"]);
        $totcptmessage=$em->getRepository("App\Entity\Statistic")->findOneBy(["keyvalue"=>"totcptmessage"]);
        $totcptblogarticle=$em->getRepository("App\Entity\Statistic")->findOneBy(["keyvalue"=>"totcptblogarticle"]);
        $totcptprojecttask=$em->getRepository("App\Entity\Statistic")->findOneBy(["keyvalue"=>"totcptprojecttask"]);

        //groupcptvisite
        $statistics=$em->getRepository("App\Entity\Statistic")->findBy(["keyvalue"=>"groupcptvisite"]);
        $groupcptvisite=[];
        foreach($statistics as $statistic) {
            $value=$statistic->getValue();
            $tmp=[
                "id"    => $statistic->getGroup()->getId(),
                "name"  => $statistic->getGroup()->getLabel(),
                "value" => end($value),
            ];
            array_push($groupcptvisite,$tmp);
        }
        usort($groupcptvisite, function($a, $b) {
            return $a['value'] <=> $b['value'];
        });
        $topgroupcptvisite = array_slice($groupcptvisite, -20);

        //groupcptmessage
        $statistics=$em->getRepository("App\Entity\Statistic")->findBy(["keyvalue"=>"groupcptmessage"]);
        $groupcptmessage=[];
        foreach($statistics as $statistic) {
            $value=$statistic->getValue();
            $tmp=[
                "id"    => $statistic->getGroup()->getId(),
                "name"  => $statistic->getGroup()->getLabel(),
                "value" => end($value),
            ];
            array_push($groupcptmessage,$tmp);
        }
        usort($groupcptmessage, function($a, $b) {
            return $a['value'] <=> $b['value'];
        });
        $topgroupcptmessage = array_slice($groupcptmessage, -20);

        //groupcptblogarticle
        $statistics=$em->getRepository("App\Entity\Statistic")->findBy(["keyvalue"=>"groupcptblogarticle"]);
        $groupcptblogarticle=[];
        foreach($statistics as $statistic) {
            $value=$statistic->getValue();
            $tmp=[
                "id"    => $statistic->getGroup()->getId(),
                "name"  => $statistic->getGroup()->getLabel(),
                "value" => end($value),
            ];
            array_push($groupcptblogarticle,$tmp);
        }
        usort($groupcptblogarticle, function($a, $b) {
            return $a['value'] <=> $b['value'];
        });
        $topgroupcptblogarticle = array_slice($groupcptblogarticle, -20);

        //groupcptprojecttask
        $statistics=$em->getRepository("App\Entity\Statistic")->findBy(["keyvalue"=>"groupcptprojecttask"]);
        $groupcptprojecttask=[];
        foreach($statistics as $statistic) {
            $value=$statistic->getValue();
            $tmp=[
                "id"    => $statistic->getGroup()->getId(),
                "name"  => $statistic->getGroup()->getLabel(),
                "value" => end($value),
            ];
            array_push($groupcptprojecttask,$tmp);
        }
        usort($groupcptprojecttask, function($a, $b) {
            return $a['value'] <=> $b['value'];
        });
        $topgroupcptprojecttask = array_slice($groupcptprojecttask, -20);



        return $this->render('Statistic\list.html.twig',[
            'useheader'             => true,
            'usemenu'               => false,
            'usesidebar'            => true,
            'totcptvisite'          => $totcptvisite,
            'totcptvisitegroup'     => $totcptvisitegroup,
            'totcptmessage'         => $totcptmessage,
            'totcptblogarticle'     => $totcptblogarticle,
            'totcptprojecttask'     => $totcptprojecttask,
            'groupcptvisite'        => $topgroupcptvisite,
            'groupcptmessage'       => $topgroupcptmessage,
            'groupcptblogarticle'   => $topgroupcptblogarticle,
            'groupcptprojecttask'   => $topgroupcptprojecttask,
        ]);        
    }
}
