<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;

class CropController extends AbstractController
{
    // Etape 01 - Téléchargement de l'image
    public function crop01()
    {
        return $this->render('Crop\crop01.html.twig',[
            'useheader'     => false,
            'usemenu'       => false,
            'usesidebar'    => false,             
        ]);
    }

    // Etape 02 - Couper votre l'image
    public function crop02(Request $request)
    {
        // Récupération de l'image à cropper
        $session = $request->getSession();
	    $large_image_location = "uploads/avatar/".$session->get('uploadavatar');

        // Récupérer les tailles de l'image
		$width = $this->getWidth($large_image_location);
		$height = $this->getHeight($large_image_location);

		// Définir le pourcentage de réduction de l'image
		$max_height=500;
		$max_width=756;
		$scale = $max_height/$height;
		if(($width*$scale)>$max_width) {
			$scale = $max_width/$width;
		}
		$this->resizeImage($large_image_location,$width,$height,$scale);

        // Construction du formulaire
        $form = $this->createFormBuilder()
            ->add('submit',SubmitType::class,array("label" => "Valider","attr" => array("class" => "btn btn-success","onclick" => "reportThumb()")))
            ->add('x1',HiddenType::class)
            ->add('y1',HiddenType::class)
            ->add('x2',HiddenType::class)
            ->add('y2',HiddenType::class)
            ->add('w',HiddenType::class)
            ->add('h',HiddenType::class)
            ->getForm();

        // Récupération des data du formulaire
        $form->handleRequest($request);

        // Sur validation on généère la miniature croppée
        if ($form->get('submit')->isClicked() && $form->isValid()) {
            // Récupération des valeurs du formulaire
            $data = $form->getData();

		    $thumb_image_location = "uploads/avatar/thumb_".$session->get('uploadavatar');;
		    $cropped = $this->resizeThumbnailImage($thumb_image_location, $large_image_location,$data["w"],$data["h"],$data["x1"],$data["y1"],$scale);
        }

        return $this->render('Crop\crop02.html.twig', [
            'useheader'     => false,
            'usemenu'       => false,
            'usesidebar'    => false,
            'form'          => $form->createView(),
        ]);
    }

	// Calcul de la hauteur
	protected function getHeight($image) {
		$size = getimagesize($image);
		$height = $size[1];
		return $height;
	}

	// Cacul de la largeur
	protected function getWidth($image) {
		$size = getimagesize($image);
		$width = $size[0];
		return $width;
	}

	protected function resizeImage($image,$width,$height,$scale) {
		list($imagewidth, $imageheight, $imageType) = getimagesize($image);
		$imageType = image_type_to_mime_type($imageType);
		$newImageWidth = ceil($width * $scale);
		$newImageHeight = ceil($height * $scale);
		$newImage = imagecreatetruecolor($newImageWidth,$newImageHeight);
		switch($imageType) {
			case "image/gif":
				$source=imagecreatefromgif($image);
				break;
			case "image/pjpeg":
			case "image/jpeg":
			case "image/jpg":
				$source=imagecreatefromjpeg($image);
				break;
			case "image/png":
			case "image/x-png":
				$source=imagecreatefrompng($image);
				break;
		}
		imagecopyresampled($newImage,$source,0,0,0,0,$newImageWidth,$newImageHeight,$width,$height);

		switch($imageType) {
			case "image/gif":
				imagegif($newImage,$image);
				break;
			case "image/pjpeg":
			case "image/jpeg":
			case "image/jpg":
				imagejpeg($newImage,$image,90);
				break;
			case "image/png":
			case "image/x-png":
				imagepng($newImage,$image);
				break;
		}

		chmod($image, 0640);
		return $image;
	}

	protected function resizeThumbnailImage($thumb_image_name, $image, $width, $height, $start_width, $start_height, $scale){
		list($imagewidth, $imageheight, $imageType) = getimagesize($image);
		$imageType = image_type_to_mime_type($imageType);

		$newImageWidth = ceil($width * $scale);
		$newImageHeight = ceil($height * $scale);
		$newImage = imagecreatetruecolor($newImageWidth,$newImageHeight);
		switch($imageType) {
			case "image/gif":
				$source=imagecreatefromgif($image);
				break;
			case "image/pjpeg":
			case "image/jpeg":
			case "image/jpg":
				$source=imagecreatefromjpeg($image);
				break;
			case "image/png":
			case "image/x-png":
				$source=imagecreatefrompng($image);
				break;
		}
		imagecopyresampled($newImage,$source,0,0,$start_width,$start_height,$newImageWidth,$newImageHeight,$width,$height);
		switch($imageType) {
			case "image/gif":
				imagegif($newImage,$thumb_image_name);
				break;
			case "image/pjpeg":
			case "image/jpeg":
			case "image/jpg":
				imagejpeg($newImage,$thumb_image_name,90);
				break;
			case "image/png":
			case "image/x-png":
				imagepng($newImage,$thumb_image_name);
				break;
		}
		chmod($thumb_image_name, 0640);
		return $thumb_image_name;
	}

}
