#!/bin/bash

# Se positionner sur la racine du projet
DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"
cd ${DIR}
cd ../..
DIR=$(pwd)

# Migration Symfony*
$DIR/misc/script/migration.sh

# Copier le .env distribué
yes 2>/dev/null | cp $DIR/misc/script/.env.dist $DIR/.env

# Tester les potentielles migrations symfony à réaliser
#./scripts/migration/migration.sh

# Import des env
. $DIR/.env
. $DIR/.env.local

# Déclaration d'un proxy
if [[ "$PROXY_USE" == "1" ]]
then
    export HTTP_PROXY="$PROXY_HOST:$PROXY_PORT"
    export HTTPS_PROXY="$PROXY_HOST:$PROXY_PORT"
fi

# Suppression des logs trop ancien
if [[ -d $DIR/var/log ]]
then
find $DIR/var/log -mindepth 1 -mtime +7 -delete
fi

if [[ -f /var/log/phpcas/phpCAS-ninegate.log ]]
then
    rm -f /var/log/phpcas/phpCAS-ninegate.log
fi

# Installation des dépendances composer
echo COMPOSER = Install
export COMPOSER_ALLOW_SUPERUSER=1
composer self-update --2
composer install

# Service Websocket & Messager
service wssninegate restart
service msgninegate restart


# Permissions
echo PERMISSIONS
./misc/script/perm.sh www-data

echo 