![Logo NineGateEdispatcherBundle](README-ninegate.jpg?width=64)

# eole Ninegate : eDispatcherBundle

*Contribution Académie de la Réunion DSI4*

eDispatcherBundle est un bundle symfony 3 recréant les apis *xDesktop* permettant de récupérer les *items de bureau* et les *messages* d'annonce déclarés par l'administrateur du portail `NineGate` et d'exploiter ces données lors de la construction du Bureau fédéré de l'ENT académique via `eDispatcher`.

# CHANGELOG

Nouveautés :
- prise en compte du *flag* des catégories d'annonces héritées : `mail, rappel, attention`
- token de mise en correspondance user ninegate / edispatcher persisté pour une durée de 24h plutôt que réinit à chaque appel de /edispatcher/api/session
- mise en conformité des annonces : mémo et messages applicatifs, mise en forme, catégories par défaut
- prise en compte d'un attribut SSO permettant le profilage d'items (attribut contenant une liste de mots clés, mot clé indiqué lors de la création d'un item)
- autocreate du user lors de l'appel en session SSO de la route /edispatcher/session

# PREAMBULE : calcul d'attribut SSO => obtenir les groupes

Sur le serveur eole-sso, éditer le fichier `/usr/share/sso/app_filters/ninegate.ini` pour préciser le calcul des attributs `user_groups`, `displayName` et `ENTPersonProfils` dans la rubrique `[attributes]` ainsi qu'un attribut permettant d'associer des items automatiquement, décrit plus bas :

```
(...)
[attributes]
(...)
user_groups=user_groups
displayName=displayName
ENTPersonProfils=ENTPersonProfils
ssoitems=applications
```
/!\ l'attribut attendu dans le code du bundle pour fournir la valeur du profil national ENT est *ENTPersonProfils* (ex. National_1)

/!\ prise en compte d'un attribut facultatif *Associer automatiquement les items en fonction d'un attribut SSO*
L'attribut *ssoitems* indiqué dans l'exemple est un libellé libre à indiquer dans le gen_config si l'on choisit d'activer le profilage d'items via un attribut SSO :
La valeur de cet attribut SSO est calculé par un script python (ici applications.py qui se charge de parser un fichier YAML applications.yml)

Cet attribut est facultatif, il est utilisé sur un ninegate dit "académique" permettant le profilage de ressources communes : les items sont créés dans ninegate sans réglages de permissions, mais en indiquant un "key name" dans le champ obligatoire *Visible si attribut SSO "NOMattributSSO" égale à*.

# INSTALLATION

cloner le projet dans un dossier, ex `/ninegate/src/Cadoles/EdispatcherBundle/`

# Routes

Editer le fichier `/ninegate/app/config/routing.yml` et rajouter le bloc :

```
edispatcher:
    resource: "@CadolesEdispatcherBundle/Resources/config/routing.yml"
    prefix:   /
```

# prise en compte du Bundle

Editer le fichier `/ninegate/app/AppKernel.php` et dans l'énumération de l`array $bundles` rajouter la ligne :

```
new Cadoles\EdispatcherBundle\CadolesEdispatcherBundle(),
```

Editer le fichier `/ninegate/app/config/template.yml` et dans la section `doctrine: > orm: > entity_managers: > default: > mappings:`

```
CadolesEdispatcherBundle: ~
```

=> un `bin/console doctrine:schema:update --force` sera donc nécessaire, déclenche la création d'une table "edispatcher" qui correspond à l'entité Datasource du bundle.

# Catégories d'annonces

Pour reproduire un modèle d'annonces isofonctionnelles avec ce qui était connu sur xdesktop, il convient de créer les catégories suivantes :

- "sans categorie" (sans accent), icone chercher "stop", couleur sans effet : n'affichera pas de catégorie sur le bureau edispatcher
- "Message", icone chercher "mail" & choisir l'enveloppe, couleur #00a996
- "Rappel", icone chercher "clock", couleur #004666
- "Attention/Important", icone chercher "caution", couleur #ff9375

ou bien importer le sql suivant :

```
INSERT INTO `alertcategory`
(`id`, `icon_id`, `label`, `color`)
VALUES
(-100,	205,	'sans categorie',	NULL),
(1,	51,	'Message',	'00a996'),
(2,	154,	'Rappel',	'004666'),
(3,	217,	'Attention/Important',	'ff9375');
```

# Détail des routes implémentées par le bundle, en lien avec la cinématique des appels effectués par Edispatcher

## API debug

`/edispatcher/test`
- affiche le contenu de la table edispatcher, entité "datasource" utilisée pour établir un lien entre un user ninegate, un token et un id fourni par *edispatcher*
- affiche les attributs SSO du user en cours de session

`/edispatcher/test?id={{ username }}`
- complète la réponse précédente en affichant les groupes de l'utilisateur désigné - non lié à la session

## API Hello

`/edispatcher/public/hello`

[ETAPE 1 CINEMATIQUE DES APPELS EDISPATCHER]

`/edispatcher/api/apps/all` pour compatibilité appels xdesktop

- route non authentifiée (anonyme) interrogée par *edispatcher* pour vérifier que le serveur réponds, en l'occurence la réponse contient le mot clé "ninegate" prise en compte par *edispatcher* pour adapter les apis qui seront interrogées pour construire le bureau à partir des ressources de ce serveur.

## API Session

[ETAPE 2 CINEMATIQUE DES APPELS EDISPATCHER]

`/ninegate/edispatcher/api/session` route interrogée par fédération, la réponse fournit une valeur de token (et l'enregistre dans l'entité datasource pour l'associer au user en cours de session *token persistant pour une durée de 24h*), et retourne un attribut `adminPostit` à `true|false`

[ETAPE 4 CINEMATIQUE DES APPELS EDISPATCHER]

`/ninegate/edispatcher/api/session?id=xxx-yyy-zzz&api=_CALLBACK.setToken` l'`id` définit par *edispatcher* en étape 3 est communiqué en `GET` sur cette route, la réponse est un snippet javascript executé dans *edispatcher* en retour, lequel permet d'associer le `token` éphémère à la source de donnée identifiée par *edispatcher* `id`

## API Me

[ETAPE 3 CINEMATIQUE DES APPELS EDISPATCHER]

`/edispatcher/api/me` appelée en passant un token en `POST` (celui obtenu à l'étape 2)

- la réponse JSON contient des informations sur l'utilisateur (`display_name`, `admin_postit`), *edispatcher* associe a ces informations un `id` de source de données

## API DesktopItems

[ETAPE 5 CINEMATIQUE DES APPELS EDISPATCHER]

`/edispatcher/api/items?js=1&id={{ id }}`

`/edispatcher/api/controllers/desktopitems.php?js=1&id={{ id }}` pour compatibilité appels xdesktop

- Route appelée avec le `token` en `POST`, la réponse au format javascript (js=1) contient un chaine xml qui décrit les items de bureau, ainsi qu'une liste json précisant les url des items favoris.

## API Messages

[ETAPE 6 CINEMATIQUE DES APPELS EDISPATCHER]

`/edispatcher/api/messages` Route appelée avec le `token` en `POST` ou l'`id` en `GET`, la réponse au format javascript est exécutée à réception par *edispatcher* et alimente le panneau des mémos avec les éventuels messages visibles par le user indiqué par la datasource désignée par le `token` ou l'`id`.

`/edispatcher/api/message/{idalert}/{action}` Route utilisée par *edispatcher* pour basculer l'état de visibilité des annonces "masquables".

## API Favoris

`/edispatcher/api/mxServices` Route utilisée par *edispatcher* pour basculer la mise en favori d'un item

# Cinématique des appels entre eDispatcher et Ninegate(s)

![Logo NineGateEdispatcherBundle](README-cinematique.png)
