#!/bin/bash


function upnineconfig {
    if [[ $NINECONFIG_ACTIVATE == 1 && $NINECONFIG_LOCAL == 1 ]]
    then
        Title ${NINECONFIG_SERVICE_NAME^^}

        if [[ $MARIADB_ACTIVATE == 1 && $MARIADB_LOCAL == 1 ]]
        then
            EchoVert "DATABASE"
            Echo ${NINECONFIG_SERVICE_NAME^^}
            docker-compose exec $MARIADB_SERVICE_NAME /nine/init.sh $NINECONFIG_SERVICE_NAME
            Echo
        fi

        EchoVert "CONTAINER"
        upservice ${NINECONFIG_SERVICE_NAME}
        Echo
    fi    
}

function destroynineconfig {
    if [[ $NINECONFIG_LOCAL == 1 ]]
    then
        Title "DESTROY $NINECONFIG_SERVICE_NAME"

        stop $NINECONFIG_SERVICE_NAME 1
        docker-compose rm -s -v -f "$NINECONFIG_SERVICE_NAME"
        
        if [[ -z $1 ]]; then 
            Question_ouinon "Souhaitez-vous supprimer la BDD associé à $NINECONFIG_SERVICE_NAME ?";
            response=$?
        fi
        if [[ "$response" == 0 || ! -z $1 ]]
        then
            EchoRouge "Delete BDD = $NINECONFIG_SERVICE_NAME"
            docker-compose exec $MARIADB_SERVICE_NAME /nine/delete.sh $NINECONFIG_SERVICE_NAME
        fi

        echo ""
    fi   
}