#!/bin/bash


function upwordpress {
    if [[ $WORDPRESS_ACTIVATE == 1 && $WORDPRESS_LOCAL == 1 ]]
    then
        Title ${WORDPRESS_SERVICE_NAME^^}
        
        if [[ $MARIADB_ACTIVATE == 1 && $MARIADB_LOCAL == 1 ]]
        then
            EchoVert "DATABASE"
            Echo ${WORDPRESS_SERVICE_NAME^^}
            docker-compose exec $MARIADB_SERVICE_NAME /nine/init.sh $WORDPRESS_SERVICE_NAME
            Echo
        fi   
        
        EchoVert "CONTAINER"
        upservice ${WORDPRESS_SERVICE_NAME}
        Echo
    fi    
}

function destroywordpress {
    if [[ $WORDPRESS_LOCAL == 1 ]]
    then
        Title "DESTROY $WORDPRESS_SERVICE_NAME"

        stop $WORDPRESS_SERVICE_NAME 1
        docker-compose rm -s -v -f "$WORDPRESS_SERVICE_NAME"
        
        if [[ -z $1 ]]; then 
            Question_ouinon "Souhaitez-vous supprimer la BDD associé à $WORDPRESS_SERVICE_NAME ?";
            response=$?
        fi
        if [[ "$response" == 0 || ! -z $1 ]]
        then
            EchoRouge "Delete BDD = $WORDPRESS_SERVICE_NAME"
            docker-compose exec $MARIADB_SERVICE_NAME /nine/delete.sh $WORDPRESS_SERVICE_NAME
            rm -rf services/50-wordpress/volume/data
        fi

        echo ""
    fi   
}