#!/bin/bash


function uppiwigo {
    if [[ $PIWIGO_ACTIVATE == 1 && $PIWIGO_LOCAL == 1 ]]
    then
        Title ${PIWIGO_SERVICE_NAME^^}

        if [[ $MARIADB_ACTIVATE == 1 && $MARIADB_LOCAL == 1 ]]
        then
            EchoVert "DATABASE"
            Echo ${PIWIGO_SERVICE_NAME^^}
            docker-compose exec $MARIADB_SERVICE_NAME /nine/init.sh $PIWIGO_SERVICE_NAME
            Echo
        fi

        EchoVert "CONTAINER"
        upservice ${PIWIGO_SERVICE_NAME}
        chmod -R a+wr ./services/50-piwigo/volume/data
        Echo
    fi    
}

function destroypiwigo {
    if [[ $PIWIGO_LOCAL == 1 ]]
    then
        Title "DESTROY $PIWIGO_SERVICE_NAME"

        stop $PIWIGO_SERVICE_NAME 1
        docker-compose rm -s -v -f "$PIWIGO_SERVICE_NAME"
        
        if [[ -z $1 ]]; then 
            Question_ouinon "Souhaitez-vous supprimer la BDD associé à $PIWIGO_SERVICE_NAME ?";
            response=$?
        fi
        if [[ "$response" == 0 || ! -z $1 ]]
        then
            EchoRouge "Delete BDD = $PIWIGO_SERVICE_NAME"
            docker-compose exec $MARIADB_SERVICE_NAME /nine/delete.sh $PIWIGO_SERVICE_NAME
            rm -rf services/50-piwigo/volume/data
        fi

        echo ""
    fi   
}