#!/bin/bash


function upnineschool {
    if [[ $NINESCHOOL_ACTIVATE == 1 && $NINESCHOOL_LOCAL == 1 ]]
    then
        Title ${NINESCHOOL_SERVICE_NAME^^}

        if [[ $MARIADB_ACTIVATE == 1 && $MARIADB_LOCAL == 1 ]]
        then
            EchoVert "DATABASE"
            Echo ${NINESCHOOL_SERVICE_NAME^^}
            docker-compose exec $MARIADB_SERVICE_NAME /nine/init.sh $NINESCHOOL_SERVICE_NAME
            Echo
        fi

        EchoVert "CONTAINER"
        upservice ${NINESCHOOL_SERVICE_NAME}
        chmod -R a+wr ./services/50-nineschool/volume/data
        Echo
    fi    
}

function destroynineschool {
    if [[ $NINESCHOOL_LOCAL == 1 ]]
    then
        Title "DESTROY $NINESCHOOL_SERVICE_NAME"

        stop $NINESCHOOL_SERVICE_NAME 1
        docker-compose rm -s -v -f "$NINESCHOOL_SERVICE_NAME"
        
        if [[ -z $1 ]]; then 
            Question_ouinon "Souhaitez-vous supprimer la BDD associé à $NINESCHOOL_SERVICE_NAME ?";
            response=$?
        fi
        if [[ "$response" == 0 || ! -z $1 ]]
        then
            EchoRouge "Delete BDD = $NINESCHOOL_SERVICE_NAME"
            docker-compose exec $MARIADB_SERVICE_NAME /nine/delete.sh $NINESCHOOL_SERVICE_NAME
            rm -rf services/50-nineschool/volume/data
        fi

        echo ""
    fi   
}