#!/bin/bash


function upninegate {
    if [[ $NINEGATE_ACTIVATE == 1 && $NINEGATE_LOCAL == 1 ]]
    then
        Title ${NINEGATE_SERVICE_NAME^^}

        if [[ $MARIADB_ACTIVATE == 1 && $MARIADB_LOCAL == 1 ]]
        then
            EchoVert "DATABASE"
            Echo ${NINEGATE_SERVICE_NAME^^}
            docker-compose exec $MARIADB_SERVICE_NAME /nine/init.sh $NINEGATE_SERVICE_NAME
            Echo
        fi

        EchoVert "CONTAINER"
        upservice ${NINEGATE_SERVICE_NAME}
        chmod -R a+wr ./services/50-ninegate/volume/data
        Echo
    fi    
}

function destroyninegate {
    if [[ $NINEGATE_LOCAL == 1 ]]
    then
        Title "DESTROY $NINEGATE_SERVICE_NAME"

        stop $NINEGATE_SERVICE_NAME 1
        docker-compose rm -s -v -f "$NINEGATE_SERVICE_NAME"
        
        if [[ -z $1 ]]; then 
            Question_ouinon "Souhaitez-vous supprimer la BDD associé à $NINEGATE_SERVICE_NAME ?";
            response=$?
        fi
        if [[ "$response" == 0 || ! -z $1 ]]
        then
            EchoRouge "Delete BDD = $NINEGATE_SERVICE_NAME"
            docker-compose exec $MARIADB_SERVICE_NAME /nine/delete.sh $NINEGATE_SERVICE_NAME
            rm -rf services/50-ninegate/volume/data
        fi

        echo ""
    fi   
}